/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.raw.udp;

import com.codahale.metrics.MetricRegistry;
import org.graylog2.inputs.network.PacketInformationDumper;
import org.graylog2.inputs.raw.RawDispatcher;
import org.graylog2.plugin.buffers.Buffer;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.inputs.util.ThroughputCounter;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;

public class RawUDPPipelineFactory
implements ChannelPipelineFactory {
    private final MetricRegistry metricRegistry;
    private final Buffer processBuffer;
    private final Configuration config;
    private final MessageInput sourceInput;
    private final ThroughputCounter throughputCounter;

    public RawUDPPipelineFactory(MetricRegistry metricRegistry, Buffer processBuffer, Configuration config, MessageInput sourceInput, ThroughputCounter throughputCounter) {
        this.metricRegistry = metricRegistry;
        this.processBuffer = processBuffer;
        this.config = config;
        this.sourceInput = sourceInput;
        this.throughputCounter = throughputCounter;
    }

    @Override
    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline p = Channels.pipeline();
        p.addLast("packet-meta-dumper", new PacketInformationDumper(this.sourceInput));
        p.addLast("traffic-counter", this.throughputCounter);
        p.addLast("handler", new RawDispatcher(this.metricRegistry, this.processBuffer, this.config, this.sourceInput));
        return p;
    }
}

