/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.raw.udp;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import org.graylog2.inputs.raw.RawInputBase;
import org.graylog2.inputs.raw.udp.RawUDPPipelineFactory;
import org.graylog2.plugin.buffers.Buffer;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.inputs.MisfireException;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.FixedReceiveBufferSizePredictorFactory;
import org.jboss.netty.channel.socket.nio.NioDatagramChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawUDPInput
extends RawInputBase {
    private static final Logger LOG = LoggerFactory.getLogger(RawUDPInput.class);
    public static final String NAME = "Raw/Plaintext UDP";
    private final MetricRegistry metricRegistry;

    @Inject
    public RawUDPInput(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    @Override
    public void initialize(Configuration configuration) {
        super.initialize(configuration);
        for (Map.Entry<String, Gauge<Long>> gauge : this.throughputCounter.gauges().entrySet()) {
            this.metricRegistry.register(MetricRegistry.name(this.getUniqueReadableId(), gauge.getKey()), (Metric)gauge.getValue());
        }
    }

    @Override
    public void launch(Buffer processBuffer) throws MisfireException {
        ExecutorService workerThreadPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("input-" + this.getId() + "-rawudp-worker-%d").build());
        this.bootstrap = new ConnectionlessBootstrap(new NioDatagramChannelFactory(workerThreadPool));
        this.bootstrap.setOption("receiveBufferSizePredictorFactory", new FixedReceiveBufferSizePredictorFactory(8192));
        this.bootstrap.setPipelineFactory(new RawUDPPipelineFactory(this.metricRegistry, processBuffer, this.configuration, this, this.throughputCounter));
        this.bootstrap.setOption("receiveBufferSize", this.getRecvBufferSize());
        try {
            this.channel = ((ConnectionlessBootstrap)this.bootstrap).bind(this.socketAddress);
            LOG.info("Started UDP raw/plaintext input on {}", (Object)this.socketAddress);
        }
        catch (ChannelException e) {
            String msg = "Could not bind UDP raw/plaintext input to address " + this.socketAddress;
            LOG.error(msg, e);
            throw new MisfireException(msg, e);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }
}

