/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.raw.tcp;

import com.codahale.metrics.MetricRegistry;
import org.graylog2.inputs.network.PacketInformationDumper;
import org.graylog2.inputs.raw.RawDispatcher;
import org.graylog2.plugin.buffers.Buffer;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.inputs.util.ConnectionCounter;
import org.graylog2.plugin.inputs.util.ThroughputCounter;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.frame.DelimiterBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.Delimiters;

public class RawTCPPipelineFactory
implements ChannelPipelineFactory {
    private final MetricRegistry metricRegistry;
    private final Buffer processBuffer;
    private final Configuration config;
    private final MessageInput sourceInput;
    private final ThroughputCounter throughputCounter;
    private final ConnectionCounter connectionCounter;

    public RawTCPPipelineFactory(MetricRegistry metricRegistry, Buffer processBuffer, Configuration config, MessageInput sourceInput, ThroughputCounter throughputCounter, ConnectionCounter connectionCounter) {
        this.metricRegistry = metricRegistry;
        this.processBuffer = processBuffer;
        this.config = config;
        this.sourceInput = sourceInput;
        this.throughputCounter = throughputCounter;
        this.connectionCounter = connectionCounter;
    }

    @Override
    public ChannelPipeline getPipeline() throws Exception {
        ChannelBuffer[] delimiter = this.config.getBoolean("use_null_delimiter") ? Delimiters.nulDelimiter() : Delimiters.lineDelimiter();
        ChannelPipeline p = Channels.pipeline();
        p.addLast("packet-meta-dumper", new PacketInformationDumper(this.sourceInput));
        p.addLast("connection-counter", this.connectionCounter);
        p.addLast("traffic-counter", this.throughputCounter);
        p.addLast("framer", new DelimiterBasedFrameDecoder(0x200000, delimiter));
        p.addLast("handler", new RawDispatcher(this.metricRegistry, this.processBuffer, this.config, this.sourceInput));
        return p;
    }
}

