/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.raw;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.net.InetAddress;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.buffers.Buffer;
import org.graylog2.plugin.buffers.BufferOutOfCapacityException;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.inputs.MessageInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(RawProcessor.class);
    private final Buffer processBuffer;
    private final Configuration config;
    private final MessageInput sourceInput;
    private final Meter incomingMessages;
    private final Meter failures;
    private final Meter incompleteMessages;
    private final Meter processedMessages;
    private final Timer parseTime;

    public RawProcessor(MetricRegistry metricRegistry, Buffer processBuffer, Configuration config, MessageInput sourceInput) {
        this.processBuffer = processBuffer;
        this.config = config;
        this.sourceInput = sourceInput;
        String metricName = sourceInput.getUniqueReadableId();
        this.incomingMessages = metricRegistry.meter(MetricRegistry.name(metricName, "incomingMessages"));
        this.failures = metricRegistry.meter(MetricRegistry.name(metricName, "failures"));
        this.processedMessages = metricRegistry.meter(MetricRegistry.name(metricName, "processedMessages"));
        this.incompleteMessages = metricRegistry.meter(MetricRegistry.name(metricName, "incompleteMessages"));
        this.parseTime = metricRegistry.timer(MetricRegistry.name(metricName, "parseTime"));
    }

    public void messageReceived(String msg, InetAddress remoteAddress) throws BufferOutOfCapacityException {
        Message lm;
        this.incomingMessages.mark();
        try {
            lm = new Message(msg, this.parseSource(msg, remoteAddress), Tools.iso8601());
        }
        catch (Exception e) {
            this.failures.mark();
            LOG.error("Could not parse raw message. Not further handling.", e);
            return;
        }
        if (!lm.isComplete()) {
            this.incompleteMessages.mark();
            LOG.debug("Skipping incomplete message.");
            return;
        }
        LOG.debug("Adding received raw message <{}> to process buffer: {}", (Object)lm.getId(), (Object)lm);
        this.processedMessages.mark();
        this.processBuffer.insertCached(lm, this.sourceInput);
    }

    private String parseSource(String msg, InetAddress remoteAddress) {
        if (this.config.stringIsSet("override_source")) {
            return this.config.getString("override_source");
        }
        return remoteAddress.getCanonicalHostName();
    }
}

