/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.raw;

import java.net.InetSocketAddress;
import java.util.Map;
import javax.inject.Inject;
import org.graylog2.plugin.buffers.Buffer;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationException;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.TextField;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.inputs.MisfireException;
import org.graylog2.plugin.inputs.util.ConnectionCounter;
import org.graylog2.plugin.inputs.util.ThroughputCounter;
import org.jboss.netty.bootstrap.Bootstrap;
import org.jboss.netty.channel.Channel;

public abstract class RawInputBase
extends MessageInput {
    public static final String CK_BIND_ADDRESS = "bind_address";
    public static final String CK_PORT = "port";
    public static final String CK_OVERRIDE_SOURCE = "override_source";
    protected Bootstrap bootstrap;
    protected Channel channel;
    @Inject
    protected ThroughputCounter throughputCounter;
    @Inject
    protected ConnectionCounter connectionCounter;
    protected InetSocketAddress socketAddress;

    @Override
    public void checkConfiguration(Configuration configuration) throws ConfigurationException {
        if (!this.checkConfig(configuration)) {
            throw new ConfigurationException(configuration.getSource().toString());
        }
        this.socketAddress = new InetSocketAddress(configuration.getString(CK_BIND_ADDRESS), (int)configuration.getInt(CK_PORT));
    }

    @Override
    public void stop() {
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.close();
        }
        if (this.bootstrap != null) {
            this.bootstrap.shutdown();
        }
    }

    @Override
    public ConfigurationRequest getRequestedConfiguration() {
        ConfigurationRequest r = new ConfigurationRequest();
        r.addField(ConfigurationRequest.Templates.bindAddress(CK_BIND_ADDRESS));
        r.addField(ConfigurationRequest.Templates.portNumber(CK_PORT, 5555));
        r.addField(new TextField(CK_OVERRIDE_SOURCE, "Override source", null, "The source is a hostname derived from the received packet by default. Set this if you want to override it with a custom string.", ConfigurationField.Optional.OPTIONAL));
        r.addField(ConfigurationRequest.Templates.recvBufferSize("recv_buffer_size", 0x100000));
        return r;
    }

    @Override
    public boolean isExclusive() {
        return false;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.configuration.getSource();
    }

    protected boolean checkConfig(Configuration config) {
        return config.stringIsSet(CK_BIND_ADDRESS) && config.intIsSet(CK_PORT);
    }

    @Override
    public String getName() {
        throw new RuntimeException("Must be overridden in syslog input classes.");
    }

    @Override
    public void launch(Buffer processBuffer) throws MisfireException {
        throw new RuntimeException("Must be overridden in syslog input classes.");
    }

    @Override
    public String linkToDocs() {
        return "";
    }
}

