/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.raw;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import java.net.InetSocketAddress;
import org.graylog2.inputs.raw.RawProcessor;
import org.graylog2.plugin.buffers.Buffer;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.inputs.MessageInput;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.socket.DatagramChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawDispatcher
extends SimpleChannelHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RawDispatcher.class);
    private final RawProcessor processor;
    private final Meter receivedMessages;

    public RawDispatcher(MetricRegistry metricRegistry, Buffer processBuffer, Configuration config, MessageInput sourceInput) {
        this.processor = new RawProcessor(metricRegistry, processBuffer, config, sourceInput);
        this.receivedMessages = metricRegistry.meter(MetricRegistry.name(sourceInput.getUniqueReadableId(), "receivedMessages"));
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        this.receivedMessages.mark();
        InetSocketAddress remoteAddress = (InetSocketAddress)e.getRemoteAddress();
        ChannelBuffer buffer = (ChannelBuffer)e.getMessage();
        byte[] readable = new byte[buffer.readableBytes()];
        buffer.toByteBuffer().get(readable, buffer.readerIndex(), buffer.readableBytes());
        this.processor.messageReceived(new String(readable), remoteAddress.getAddress());
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        LOG.debug("Could not handle raw message.", e.getCause());
        if (ctx.getChannel() != null && !(ctx.getChannel() instanceof DatagramChannel)) {
            ctx.getChannel().close();
        }
    }
}

