/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.random.generators;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.graylog2.inputs.random.generators.Tools;
import org.graylog2.plugin.Message;

public class FakeHttpMessageGenerator {
    private static final int MAX_WEIGHT = 50;
    private final String source;
    private final Random rand = new Random(System.currentTimeMillis());
    private final List<Weighted> GET_RESOURCES = new ArrayList<Weighted>(){
        {
            this.add(new Resource("/login", "LoginController", "login", 10));
            this.add(new Resource("/users", "UsersController", "index", 2));
            this.add(new Resource("/posts", "PostsController", "index", 40));
            this.add(new Resource("/posts/45326", "PostsController", "show", 12));
            this.add(new Resource("/posts/45326/edit", "PostsController", "edit", 1));
        }
    };
    private final List<Weighted> USER_IDS = new ArrayList<Weighted>(){
        {
            this.add(new UserId(9001, 10));
            this.add(new UserId(54351, 1));
            this.add(new UserId(74422, 5));
            this.add(new UserId(6476752, 12));
            this.add(new UserId(6469981, 40));
        }
    };

    public FakeHttpMessageGenerator(String source) {
        this.source = source;
    }

    public Message generate() {
        boolean isSuccessful;
        int x2 = this.rand.nextInt(100);
        int y = this.rand.nextInt(100);
        boolean bl = isSuccessful = y < 98;
        if (x2 <= 95) {
            return this.buildGETMessage(isSuccessful);
        }
        if (x2 > 95 && x2 <= 98) {
            return this.buildPOSTMessage(isSuccessful);
        }
        if (x2 == 99) {
            return this.buildDELETEMessage(isSuccessful);
        }
        return this.buildPUTMessage(isSuccessful);
    }

    private String shortMessage(String method, String resource, int code, int tookMs) {
        StringBuilder sb = new StringBuilder();
        sb.append(method).append(" ").append(resource).append(" [").append(code).append("]").append(" ").append(tookMs).append("ms");
        return sb.toString();
    }

    private <T extends Weighted> T getWeighted(List<Weighted> list2) {
        int x2;
        Weighted obj;
        do {
            x2 = this.rand.nextInt(50);
        } while ((obj = list2.get(this.rand.nextInt(list2.size()))).getWeight() < x2);
        return (T)obj;
    }

    private Message buildGETMessage(boolean isSuccessful) {
        return this.get(isSuccessful);
    }

    private Message get(boolean isSuccessful) {
        int code;
        Resource resource = (Resource)this.getWeighted(this.GET_RESOURCES);
        int msBase = 100;
        int deviation = 30;
        int n = code = isSuccessful ? 200 : 500;
        if (!isSuccessful && this.rand.nextInt(5) == 1) {
            msBase = 5000;
            deviation = 10;
            code = 504;
        } else if (this.rand.nextInt(500) == 1) {
            msBase = 400;
        }
        int tookMs = Tools.deviation(msBase, deviation, this.rand);
        UserId userId = (UserId)this.getWeighted(this.USER_IDS);
        Message msg = new Message(this.shortMessage("GET", resource.getResource(), code, tookMs), this.source, org.graylog2.plugin.Tools.iso8601());
        msg.addField("http_method", "GET");
        msg.addField("http_response_code", code);
        msg.addField("resource", resource.getResource());
        msg.addField("controller", resource.getController());
        msg.addField("action", resource.getAction());
        msg.addField("user_id", userId.getId());
        msg.addField("took_ms", tookMs);
        return msg;
    }

    private Message buildPOSTMessage(boolean isSuccessful) {
        return isSuccessful ? this.successfulPOST() : this.failedPOST();
    }

    private Message successfulPOST() {
        return new Message("successful POST", this.source, org.graylog2.plugin.Tools.iso8601());
    }

    private Message failedPOST() {
        return new Message("failed POST", this.source, org.graylog2.plugin.Tools.iso8601());
    }

    private Message buildPUTMessage(boolean isSuccessful) {
        return isSuccessful ? this.successfulPUT() : this.failedPUT();
    }

    private Message successfulPUT() {
        return new Message("successful PUT", this.source, org.graylog2.plugin.Tools.iso8601());
    }

    private Message failedPUT() {
        return new Message("failed PUT", this.source, org.graylog2.plugin.Tools.iso8601());
    }

    private Message buildDELETEMessage(boolean isSuccessful) {
        return isSuccessful ? this.successfulDELETE() : this.failedDELETE();
    }

    private Message successfulDELETE() {
        return new Message("successful DELETE", this.source, org.graylog2.plugin.Tools.iso8601());
    }

    private Message failedDELETE() {
        return new Message("failed DELETE", this.source, org.graylog2.plugin.Tools.iso8601());
    }

    private class UserId
    extends Weighted {
        private final int id;

        public UserId(int id, int weight) {
            super(weight);
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }

    private class Resource
    extends Weighted {
        private final String resource;
        private final String controller;
        private final String action;

        public Resource(String resource, String controller, String action, int weight) {
            super(weight);
            this.resource = resource;
            this.controller = controller;
            this.action = action;
        }

        public String getResource() {
            return this.resource;
        }

        public String getController() {
            return this.controller;
        }

        public String getAction() {
            return this.action;
        }
    }

    private abstract class Weighted {
        protected final int weight;

        protected Weighted(int weight) {
            if (weight <= 0 || weight > 50) {
                throw new RuntimeException("Invalid resource weight: " + weight);
            }
            this.weight = weight;
        }

        public int getWeight() {
            return this.weight;
        }
    }
}

