/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.random;

import java.util.Map;
import java.util.Random;
import javax.inject.Inject;
import org.graylog2.inputs.random.generators.FakeHttpMessageGenerator;
import org.graylog2.inputs.random.generators.Tools;
import org.graylog2.plugin.buffers.Buffer;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationException;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.NumberField;
import org.graylog2.plugin.configuration.fields.TextField;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.inputs.MisfireException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FakeHttpMessageInput
extends MessageInput {
    private static final Logger LOG = LoggerFactory.getLogger(FakeHttpMessageInput.class);
    public static final String NAME = "Random HTTP message generator";
    public static final String CK_SOURCE = "source";
    public static final String CK_SLEEP = "sleep";
    public static final String CK_SLEEP_DEVIATION_PERCENT = "sleep_deviation";
    private final Random rand = new Random();
    private boolean stopRequested = false;
    private String source;
    private int sleepMs;
    private int maxSleepDeviation;

    @Inject
    public FakeHttpMessageInput() {
    }

    @Override
    public void checkConfiguration(Configuration configuration) throws ConfigurationException {
        if (!this.checkConfig(configuration)) {
            throw new ConfigurationException(configuration.getSource().toString());
        }
        this.source = configuration.getString(CK_SOURCE);
        this.sleepMs = (int)configuration.getInt(CK_SLEEP);
        this.maxSleepDeviation = (int)configuration.getInt(CK_SLEEP_DEVIATION_PERCENT);
    }

    @Override
    public void launch(final Buffer processBuffer) throws MisfireException {
        final FakeHttpMessageInput thisInput = this;
        final FakeHttpMessageGenerator generator = new FakeHttpMessageGenerator(this.source);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!FakeHttpMessageInput.this.stopRequested) {
                    processBuffer.insertCached(generator.generate(), thisInput);
                    try {
                        Thread.sleep(Tools.deviation(FakeHttpMessageInput.this.sleepMs, FakeHttpMessageInput.this.maxSleepDeviation, FakeHttpMessageInput.this.rand));
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
                FakeHttpMessageInput.this.stopRequested = false;
            }
        });
        t.start();
    }

    @Override
    public void stop() {
        this.stopRequested = true;
    }

    @Override
    public ConfigurationRequest getRequestedConfiguration() {
        ConfigurationRequest c = new ConfigurationRequest();
        c.addField(new NumberField(CK_SLEEP, "Sleep time", 25, "How many milliseconds to sleep between generating messages.", ConfigurationField.Optional.NOT_OPTIONAL, NumberField.Attribute.ONLY_POSITIVE));
        c.addField(new NumberField(CK_SLEEP_DEVIATION_PERCENT, "Maximum random sleep time deviation", 30, "The deviation is used to generate a more realistic and non-steady message flow.", ConfigurationField.Optional.NOT_OPTIONAL, NumberField.Attribute.ONLY_POSITIVE));
        c.addField(new TextField(CK_SOURCE, "Source name", "example.org", "What to use as source of the generate messages.", ConfigurationField.Optional.NOT_OPTIONAL));
        return c;
    }

    @Override
    public boolean isExclusive() {
        return false;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String linkToDocs() {
        return "";
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.configuration.getSource();
    }

    private boolean checkConfig(Configuration config) {
        return config.stringIsSet(CK_SOURCE) && config.intIsSet(CK_SLEEP) && config.intIsSet(CK_SLEEP_DEVIATION_PERCENT);
    }
}

