/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.radio;

import com.codahale.metrics.MetricRegistry;
import com.google.common.eventbus.EventBus;
import com.google.inject.Inject;
import org.graylog2.inputs.amqp.AMQPInput;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationException;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.NumberField;
import org.graylog2.plugin.configuration.fields.TextField;

public class RadioAMQPInput
extends AMQPInput {
    public static final String NAME = "Graylog2 Radio Input (AMQP)";

    @Inject
    public RadioAMQPInput(MetricRegistry metricRegistry, EventBus eventBus) {
        super(metricRegistry, eventBus);
    }

    @Override
    public void checkConfiguration(Configuration configuration) throws ConfigurationException {
        configuration.setString("exchange", "graylog2");
        configuration.setString("queue", "graylog2-radio-messages");
        configuration.setString("routing_key", "graylog2-radio-message");
        if (!this.checkConfig(configuration)) {
            throw new ConfigurationException(configuration.getSource().toString());
        }
    }

    @Override
    public ConfigurationRequest getRequestedConfiguration() {
        ConfigurationRequest cr = new ConfigurationRequest();
        cr.addField(new TextField("broker_hostname", "Broker hostname", "", "Hostname of the AMQP broker to use", ConfigurationField.Optional.NOT_OPTIONAL));
        cr.addField(new NumberField("broker_port", "Broker port", 5672, "Port of the AMQP broker to use", ConfigurationField.Optional.OPTIONAL, NumberField.Attribute.IS_PORT_NUMBER));
        cr.addField(new TextField("broker_vhost", "Broker virtual host", "/", "Virtual host of the AMQP broker to use", ConfigurationField.Optional.NOT_OPTIONAL));
        cr.addField(new TextField("broker_username", "Username", "", "Username to connect to AMQP broker", ConfigurationField.Optional.OPTIONAL));
        cr.addField(new TextField("broker_password", "Password", "", "Password to connect to AMQP broker", ConfigurationField.Optional.OPTIONAL, TextField.Attribute.IS_PASSWORD));
        cr.addField(new NumberField("prefetch", "Prefetch count", 100, "For advanced usage: AMQP prefetch count. Default is 100.", ConfigurationField.Optional.NOT_OPTIONAL));
        return cr;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

