/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.network;

import org.graylog2.plugin.inputs.MessageInput;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketInformationDumper
extends SimpleChannelUpstreamHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PacketInformationDumper.class);
    private final Logger sourceInputLog;
    private final MessageInput sourceInput;

    public PacketInformationDumper(MessageInput sourceInput) {
        this.sourceInput = sourceInput;
        this.sourceInputLog = LoggerFactory.getLogger(PacketInformationDumper.class.getCanonicalName() + "." + sourceInput.getId());
        LOG.debug("Set {} to TRACE for network packet metadata dumps of input {}", (Object)this.sourceInputLog.getName(), (Object)sourceInput.getUniqueReadableId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        try {
            if (this.sourceInputLog.isTraceEnabled()) {
                ChannelBuffer message = (ChannelBuffer)e.getMessage();
                this.sourceInputLog.trace("Recv network data: {} bytes via input '{}' <{}> from remote address {}", message.readableBytes(), this.sourceInput.getName(), this.sourceInput.getId(), e.getRemoteAddress());
            }
        }
        finally {
            super.messageReceived(ctx, e);
        }
    }
}

