/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.misc.metrics;

import com.codahale.metrics.MetricRegistry;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.graylog2.inputs.misc.metrics.agent.Graylog2Reporter;
import org.graylog2.inputs.misc.metrics.agent.InProcessMessageWriter;
import org.graylog2.plugin.buffers.Buffer;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationException;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.DropdownField;
import org.graylog2.plugin.configuration.fields.NumberField;
import org.graylog2.plugin.configuration.fields.TextField;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.inputs.MisfireException;
import org.graylog2.plugin.system.NodeId;

public class LocalMetricsInput
extends MessageInput {
    public static final String NAME = "Internal metrics reporter";
    private final MetricRegistry metricRegistry;
    private final NodeId nodeId;
    private Graylog2Reporter reporter;
    private Graylog2Reporter.Builder builder;
    private static final String CK_REPORT_INTERVAL = "report_interval";
    private static final String CK_REPORT_UNIT = "report_unit";
    private static final String CK_DURATION_UNIT = "duration_unit";
    private static final String CK_RATE_UNIT = "rate_unit";
    private static final String CK_SOURCE = "source";

    @Inject
    public LocalMetricsInput(MetricRegistry metricRegistry, NodeId nodeId) {
        this.metricRegistry = metricRegistry;
        this.nodeId = nodeId;
    }

    @Override
    public void checkConfiguration(Configuration configuration) throws ConfigurationException {
        this.builder = Graylog2Reporter.forRegistry(this.metricRegistry).useSource(configuration.getString(CK_SOURCE)).convertDurationsTo(TimeUnit.valueOf(configuration.getString(CK_DURATION_UNIT))).convertRatesTo(TimeUnit.valueOf(configuration.getString(CK_RATE_UNIT)));
    }

    @Override
    public void launch(Buffer processBuffer) throws MisfireException {
        this.reporter = this.builder.build(new InProcessMessageWriter(processBuffer, this.nodeId.toString(), this));
        this.reporter.start(this.configuration.getInt(CK_REPORT_INTERVAL), TimeUnit.valueOf(this.configuration.getString(CK_REPORT_UNIT)));
    }

    @Override
    public void stop() {
        this.reporter.stop();
    }

    @Override
    public ConfigurationRequest getRequestedConfiguration() {
        ConfigurationRequest r = new ConfigurationRequest();
        r.addField(new TextField(CK_SOURCE, "Source", "metrics", "Define a name of the source. For example 'metrics'.", ConfigurationField.Optional.NOT_OPTIONAL));
        r.addField(new NumberField(CK_REPORT_INTERVAL, "Report interval", 10, "Time between each report. Select a time unit in the corresponding dropdown.", ConfigurationField.Optional.NOT_OPTIONAL, NumberField.Attribute.ONLY_POSITIVE));
        r.addField(new DropdownField(CK_REPORT_UNIT, "Report interval unit", TimeUnit.SECONDS.toString(), DropdownField.ValueTemplates.timeUnits(), ConfigurationField.Optional.NOT_OPTIONAL));
        r.addField(new DropdownField(CK_DURATION_UNIT, "Time unit of measured durations", TimeUnit.MILLISECONDS.toString(), DropdownField.ValueTemplates.timeUnits(), "The time unit that will be used in for example timer values. Think of: took 15ms", ConfigurationField.Optional.NOT_OPTIONAL));
        r.addField(new DropdownField(CK_RATE_UNIT, "Time unit of measured rates", TimeUnit.SECONDS.toString(), DropdownField.ValueTemplates.timeUnits(), "The time unit that will be used in for example meter values. Think of: 7 per second", ConfigurationField.Optional.NOT_OPTIONAL));
        return r;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String linkToDocs() {
        return "";
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.configuration.getSource();
    }

    @Override
    public boolean isExclusive() {
        return true;
    }
}

