/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.misc.jsonpath;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Response;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Collector {
    private static final Logger LOG = LoggerFactory.getLogger(Collector.class);
    private final String url;
    private final Map<String, String> headers;
    private final String inputId;

    public Collector(String url, Map<String, String> headers, String inputId) {
        this.url = url;
        this.headers = headers;
        this.inputId = inputId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJson() throws InterruptedException, ExecutionException, IOException {
        LOG.debug("Getting JSON for JsonPathInput <{}> from [{}].", (Object)this.inputId, (Object)this.url);
        try (AsyncHttpClient client = new AsyncHttpClient();){
            Response r;
            AsyncHttpClient.BoundRequestBuilder requestBuilder = client.prepareGet(this.url);
            if (this.headers != null) {
                for (Map.Entry<String, String> header : this.headers.entrySet()) {
                    requestBuilder.addHeader(header.getKey(), header.getValue());
                }
            }
            if ((r = (Response)requestBuilder.execute().get()).getStatusCode() != 200) {
                throw new RuntimeException("Expected HTTP status code 200, got " + r.getStatusCode());
            }
            String string2 = r.getResponseBody();
            return string2;
        }
    }
}

