/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.gelf.udp;

import com.codahale.metrics.MetricRegistry;
import org.graylog2.inputs.gelf.GELFDispatcher;
import org.graylog2.inputs.gelf.gelf.GELFChunkManager;
import org.graylog2.inputs.network.PacketInformationDumper;
import org.graylog2.plugin.buffers.Buffer;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.inputs.util.ThroughputCounter;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;

public class GELFUDPPipelineFactory
implements ChannelPipelineFactory {
    private final MetricRegistry metricRegistry;
    private final GELFChunkManager gelfChunkManager;
    private final Buffer processBuffer;
    private final MessageInput sourceInput;
    private final ThroughputCounter throughputCounter;

    public GELFUDPPipelineFactory(MetricRegistry metricRegistry, GELFChunkManager gelfChunkManager, Buffer processBuffer, MessageInput sourceInput, ThroughputCounter throughputCounter) {
        this.metricRegistry = metricRegistry;
        this.gelfChunkManager = gelfChunkManager;
        this.processBuffer = processBuffer;
        this.sourceInput = sourceInput;
        this.throughputCounter = throughputCounter;
    }

    @Override
    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline p = Channels.pipeline();
        p.addLast("packet-meta-dumper", new PacketInformationDumper(this.sourceInput));
        p.addLast("traffic-counter", this.throughputCounter);
        p.addLast("handler", new GELFDispatcher(this.metricRegistry, this.gelfChunkManager, this.processBuffer, this.sourceInput));
        return p;
    }
}

