/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.gelf.udp;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import org.graylog2.inputs.gelf.GELFInputBase;
import org.graylog2.inputs.gelf.gelf.GELFChunkManager;
import org.graylog2.inputs.gelf.udp.GELFUDPPipelineFactory;
import org.graylog2.plugin.buffers.Buffer;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.inputs.MisfireException;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.channel.FixedReceiveBufferSizePredictorFactory;
import org.jboss.netty.channel.socket.nio.NioDatagramChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GELFUDPInput
extends GELFInputBase {
    private static final Logger LOG = LoggerFactory.getLogger(GELFUDPInput.class);
    public static final String NAME = "GELF UDP";
    private final MetricRegistry metricRegistry;
    private final GELFChunkManager gelfChunkManager;

    @Inject
    public GELFUDPInput(MetricRegistry metricRegistry, GELFChunkManager gelfChunkManager) {
        this.metricRegistry = metricRegistry;
        this.gelfChunkManager = gelfChunkManager;
    }

    @Override
    public void initialize(Configuration configuration) {
        super.initialize(configuration);
        for (Map.Entry<String, Gauge<Long>> gauge : this.throughputCounter.gauges().entrySet()) {
            this.metricRegistry.register(MetricRegistry.name(this.getUniqueReadableId(), gauge.getKey()), (Metric)gauge.getValue());
        }
    }

    @Override
    public void launch(Buffer processBuffer) throws MisfireException {
        ExecutorService workerThreadPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("input-" + this.getId() + "-gelfudp-worker-%d").build());
        this.bootstrap = new ConnectionlessBootstrap(new NioDatagramChannelFactory(workerThreadPool));
        this.bootstrap.setOption("receiveBufferSizePredictorFactory", new FixedReceiveBufferSizePredictorFactory(8192));
        this.bootstrap.setPipelineFactory(new GELFUDPPipelineFactory(this.metricRegistry, this.gelfChunkManager, processBuffer, this, this.throughputCounter));
        this.bootstrap.setOption("receiveBufferSize", this.getRecvBufferSize());
        try {
            this.channel = ((ConnectionlessBootstrap)this.bootstrap).bind(this.socketAddress);
            LOG.info("Started GELF UDP input on {}", (Object)this.socketAddress);
        }
        catch (Exception e) {
            String msg = "Could not bind UDP GELF input to address " + this.socketAddress;
            LOG.error(msg, e);
            throw new MisfireException(msg);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }
}

