/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.gelf.tcp;

import com.codahale.metrics.MetricRegistry;
import org.graylog2.inputs.gelf.GELFDispatcher;
import org.graylog2.inputs.gelf.gelf.GELFChunkManager;
import org.graylog2.inputs.network.PacketInformationDumper;
import org.graylog2.plugin.buffers.Buffer;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.inputs.util.ConnectionCounter;
import org.graylog2.plugin.inputs.util.ThroughputCounter;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.frame.DelimiterBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.Delimiters;

public class GELFTCPPipelineFactory
implements ChannelPipelineFactory {
    private final MetricRegistry metricRegistry;
    private final Buffer processBuffer;
    private final GELFChunkManager gelfChunkManager;
    private final MessageInput sourceInput;
    private final ThroughputCounter throughputCounter;
    private final ConnectionCounter connectionCounter;

    public GELFTCPPipelineFactory(MetricRegistry metricRegistry, Buffer processBuffer, GELFChunkManager gelfChunkManager, MessageInput sourceInput, ThroughputCounter throughputCounter, ConnectionCounter connectionCounter) {
        this.metricRegistry = metricRegistry;
        this.processBuffer = processBuffer;
        this.gelfChunkManager = gelfChunkManager;
        this.sourceInput = sourceInput;
        this.throughputCounter = throughputCounter;
        this.connectionCounter = connectionCounter;
    }

    @Override
    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline p = Channels.pipeline();
        p.addLast("connection-counter", this.connectionCounter);
        p.addLast("packet-meta-dumper", new PacketInformationDumper(this.sourceInput));
        p.addLast("framer", new DelimiterBasedFrameDecoder(0x200000, Delimiters.nulDelimiter()));
        p.addLast("traffic-counter", this.throughputCounter);
        p.addLast("handler", new GELFDispatcher(this.metricRegistry, this.gelfChunkManager, this.processBuffer, this.sourceInput));
        return p;
    }
}

