/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.gelf.tcp;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import org.graylog2.inputs.gelf.GELFInputBase;
import org.graylog2.inputs.gelf.gelf.GELFChunkManager;
import org.graylog2.inputs.gelf.tcp.GELFTCPPipelineFactory;
import org.graylog2.plugin.buffers.Buffer;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.inputs.MisfireException;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GELFTCPInput
extends GELFInputBase {
    private static final Logger LOG = LoggerFactory.getLogger(GELFTCPInput.class);
    public static final String NAME = "GELF TCP";
    private final MetricRegistry metricRegistry;
    private final GELFChunkManager gelfChunkManager;

    @Inject
    public GELFTCPInput(MetricRegistry metricRegistry, GELFChunkManager gelfChunkManager) {
        this.metricRegistry = metricRegistry;
        this.gelfChunkManager = gelfChunkManager;
    }

    @Override
    public void initialize(Configuration configuration) {
        super.initialize(configuration);
        for (Map.Entry<String, Gauge<Long>> gauge : this.throughputCounter.gauges().entrySet()) {
            this.metricRegistry.register(MetricRegistry.name(this.getUniqueReadableId(), gauge.getKey()), (Metric)gauge.getValue());
        }
        this.metricRegistry.register(MetricRegistry.name(this.getUniqueReadableId(), "open_connections"), this.connectionCounter.gaugeCurrent());
        this.metricRegistry.register(MetricRegistry.name(this.getUniqueReadableId(), "total_connections"), this.connectionCounter.gaugeTotal());
    }

    @Override
    public void launch(Buffer processBuffer) throws MisfireException {
        ExecutorService bossThreadPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("input-" + this.getId() + "-gelftcp-boss-%d").build());
        ExecutorService workerThreadPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("input-" + this.getId() + "-gelftcp-worker-%d").build());
        this.bootstrap = new ServerBootstrap(new NioServerSocketChannelFactory((Executor)bossThreadPool, workerThreadPool));
        this.bootstrap.setPipelineFactory(new GELFTCPPipelineFactory(this.metricRegistry, processBuffer, this.gelfChunkManager, this, this.throughputCounter, this.connectionCounter));
        this.bootstrap.setOption("child.receiveBufferSize", this.getRecvBufferSize());
        try {
            this.channel = ((ServerBootstrap)this.bootstrap).bind(this.socketAddress);
            LOG.info("Started TCP GELF input on {}", (Object)this.socketAddress);
        }
        catch (Exception e) {
            String msg = "Could not bind TCP GELF input to address " + this.socketAddress;
            LOG.error(msg, e);
            throw new MisfireException(msg);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }
}

