/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.gelf.http;

import com.codahale.metrics.MetricRegistry;
import org.graylog2.inputs.gelf.gelf.GELFProcessor;
import org.graylog2.inputs.gelf.http.GELFHttpHandler;
import org.graylog2.inputs.network.PacketInformationDumper;
import org.graylog2.plugin.buffers.Buffer;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.inputs.util.ConnectionCounter;
import org.graylog2.plugin.inputs.util.ThroughputCounter;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.http.HttpContentDecompressor;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;

public class GELFHttpPipelineFactory
implements ChannelPipelineFactory {
    private final MetricRegistry metricRegistry;
    private final Buffer processBuffer;
    private final MessageInput sourceInput;
    private final ThroughputCounter throughputCounter;
    private final ConnectionCounter connectionCounter;

    public GELFHttpPipelineFactory(MetricRegistry metricRegistry, Buffer processBuffer, MessageInput sourceInput, ThroughputCounter throughputCounter, ConnectionCounter connectionCounter) {
        this.metricRegistry = metricRegistry;
        this.processBuffer = processBuffer;
        this.sourceInput = sourceInput;
        this.throughputCounter = throughputCounter;
        this.connectionCounter = connectionCounter;
    }

    @Override
    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("packet-meta-dumper", new PacketInformationDumper(this.sourceInput));
        pipeline.addLast("connection-counter", this.connectionCounter);
        pipeline.addLast("traffic-counter", this.throughputCounter);
        pipeline.addLast("decoder", new HttpRequestDecoder());
        pipeline.addLast("encoder", new HttpResponseEncoder());
        pipeline.addLast("decompressor", new HttpContentDecompressor());
        pipeline.addLast("handler", new GELFHttpHandler(this.metricRegistry, this.sourceInput, new GELFProcessor(this.metricRegistry, this.processBuffer), this.sourceInput.getConfiguration().getBoolean("enable_cors")));
        return pipeline;
    }
}

