/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.gelf.http;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import org.graylog2.inputs.gelf.GELFInputBase;
import org.graylog2.inputs.gelf.http.GELFHttpPipelineFactory;
import org.graylog2.plugin.buffers.Buffer;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.BooleanField;
import org.graylog2.plugin.inputs.MisfireException;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GELFHttpInput
extends GELFInputBase {
    private static final Logger LOG = LoggerFactory.getLogger(GELFHttpInput.class);
    public static final String NAME = "GELF HTTP";
    private final MetricRegistry metricRegistry;

    @Inject
    public GELFHttpInput(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    @Override
    public void initialize(Configuration configuration) {
        super.initialize(configuration);
        for (Map.Entry<String, Gauge<Long>> gauge : this.throughputCounter.gauges().entrySet()) {
            this.metricRegistry.register(MetricRegistry.name(this.getUniqueReadableId(), gauge.getKey()), (Metric)gauge.getValue());
        }
        this.metricRegistry.register(MetricRegistry.name(this.getUniqueReadableId(), "open_connections"), this.connectionCounter.gaugeCurrent());
        this.metricRegistry.register(MetricRegistry.name(this.getUniqueReadableId(), "total_connections"), this.connectionCounter.gaugeTotal());
    }

    @Override
    public void launch(Buffer processBuffer) throws MisfireException {
        ExecutorService bossExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("input-" + this.getId() + "-gelfhttp-boss-%d").build());
        ExecutorService workerExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("input-" + this.getId() + "-gelfhttp-worker-%d").build());
        this.bootstrap = new ServerBootstrap(new NioServerSocketChannelFactory((Executor)bossExecutor, workerExecutor));
        this.bootstrap.setPipelineFactory(new GELFHttpPipelineFactory(this.metricRegistry, processBuffer, this, this.throughputCounter, this.connectionCounter));
        try {
            this.channel = ((ServerBootstrap)this.bootstrap).bind(this.socketAddress);
            LOG.debug("Started GELF HTTP input on {}", (Object)this.socketAddress);
        }
        catch (Exception e) {
            String msg = "Could not bind GELF HTTP input to address " + this.socketAddress;
            LOG.error(msg, e);
            throw new MisfireException(msg);
        }
    }

    @Override
    public boolean isExclusive() {
        return false;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String linkToDocs() {
        return "http://support.torch.sh/help/kb/graylog2-server/using-the-gelf-http-input";
    }

    @Override
    public ConfigurationRequest getRequestedConfiguration() {
        ConfigurationRequest r = super.getRequestedConfiguration();
        r.addField(new BooleanField("enable_cors", "Enable CORS", true, "Input sends CORS headers to satisfy browser security policies"));
        return r;
    }
}

