/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.gelf.http;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import org.graylog2.inputs.gelf.gelf.GELFMessage;
import org.graylog2.inputs.gelf.gelf.GELFProcessor;
import org.graylog2.plugin.inputs.MessageInput;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GELFHttpHandler
extends SimpleChannelHandler {
    private static final Logger LOG = LoggerFactory.getLogger(GELFHttpHandler.class);
    private final Meter receivedMessages;
    private final Meter gelfMessages;
    private final MessageInput sourceInput;
    private final Boolean enableCors;
    private final GELFProcessor gelfProcessor;

    public GELFHttpHandler(MetricRegistry metricRegistry, MessageInput sourceInput, GELFProcessor gelfProcessor, Boolean enableCors) {
        this.gelfProcessor = gelfProcessor;
        this.sourceInput = sourceInput;
        this.enableCors = enableCors;
        this.receivedMessages = metricRegistry.meter(MetricRegistry.name(GELFHttpHandler.class, "receivedMessages"));
        this.gelfMessages = metricRegistry.meter(MetricRegistry.name(GELFHttpHandler.class, "gelfMessages"));
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        this.receivedMessages.mark();
        HttpRequest request = (HttpRequest)e.getMessage();
        boolean keepAlive = HttpHeaders.isKeepAlive(request);
        HttpVersion httpRequestVersion = request.getProtocolVersion();
        String origin = request.headers().get("Origin");
        if (request.getMethod() != HttpMethod.POST) {
            this.writeResponse(e.getChannel(), keepAlive, httpRequestVersion, HttpResponseStatus.METHOD_NOT_ALLOWED, origin);
            return;
        }
        ChannelBuffer buffer = request.getContent();
        byte[] message = new byte[buffer.readableBytes()];
        buffer.toByteBuffer().get(message, buffer.readerIndex(), buffer.readableBytes());
        if (!"/gelf".equals(request.getUri())) {
            this.writeResponse(e.getChannel(), keepAlive, httpRequestVersion, HttpResponseStatus.NOT_FOUND, origin);
            return;
        }
        this.gelfMessages.mark();
        GELFMessage msg = new GELFMessage(message);
        this.gelfProcessor.messageReceived(msg, this.sourceInput);
        this.writeResponse(e.getChannel(), keepAlive, httpRequestVersion, HttpResponseStatus.ACCEPTED, origin);
    }

    private void writeResponse(Channel channel, boolean keepAlive, HttpVersion httpRequestVersion, HttpResponseStatus status, String origin) {
        DefaultHttpResponse response = new DefaultHttpResponse(httpRequestVersion, status);
        response.headers().set("Content-Length", 0);
        response.headers().set("Connection", keepAlive ? "keep-alive" : "close");
        if (this.enableCors.booleanValue() && origin != null && !origin.isEmpty()) {
            response.headers().set("Access-Control-Allow-Origin", origin);
            response.headers().set("Access-Control-Allow-Credentials", true);
            response.headers().set("Access-Control-Allow-Headers", "Authorization");
        }
        ChannelFuture channelFuture = channel.write(response);
        if (!keepAlive) {
            channelFuture.addListener(ChannelFutureListener.CLOSE);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        LOG.debug("Could not handle GELF HTTP message.", e.getCause());
        if (ctx.getChannel() != null) {
            ctx.getChannel().close();
        }
    }
}

