/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.gelf.gelf;

import com.codahale.metrics.MetricRegistry;
import org.graylog2.inputs.gelf.gelf.GELFMessage;
import org.graylog2.inputs.gelf.gelf.GELFParser;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.buffers.Buffer;
import org.graylog2.plugin.buffers.BufferOutOfCapacityException;
import org.graylog2.plugin.buffers.ProcessingDisabledException;
import org.graylog2.plugin.inputs.MessageInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GELFProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(GELFProcessor.class);
    private final Buffer processBuffer;
    private MetricRegistry metricRegistry;
    private final GELFParser gelfParser;

    public GELFProcessor(MetricRegistry metricRegistry, Buffer processBuffer) {
        this(metricRegistry, processBuffer, new GELFParser(metricRegistry));
    }

    public GELFProcessor(MetricRegistry metricRegistry, Buffer processBuffer, GELFParser gelfParser) {
        this.processBuffer = processBuffer;
        this.metricRegistry = metricRegistry;
        this.gelfParser = gelfParser;
    }

    public void messageReceived(GELFMessage message, MessageInput sourceInput) throws BufferOutOfCapacityException {
        Message lm = this.prepareMessage(message, sourceInput);
        if (lm == null) {
            return;
        }
        this.processBuffer.insertCached(lm, sourceInput);
    }

    public void messageReceivedFailFast(GELFMessage message, MessageInput sourceInput) throws BufferOutOfCapacityException, ProcessingDisabledException {
        Message lm = this.prepareMessage(message, sourceInput);
        if (lm == null) {
            return;
        }
        this.processBuffer.insertFailFast(lm, sourceInput);
    }

    private Message prepareMessage(GELFMessage message, MessageInput sourceInput) {
        String metricName = sourceInput.getUniqueReadableId();
        this.metricRegistry.meter(MetricRegistry.name(metricName, "incomingMessages")).mark();
        Message lm = null;
        try {
            lm = this.gelfParser.parse(message.getJSON(), sourceInput);
        }
        catch (IllegalStateException e) {
            LOG.error("Corrupt or invalid message received: ", e);
            return null;
        }
        if (lm == null || !lm.isComplete()) {
            this.metricRegistry.meter(MetricRegistry.name(metricName, "incompleteMessages")).mark();
            LOG.debug("Skipping incomplete message: {}", (Object)lm.getValidationErrors());
            return null;
        }
        LOG.debug("Adding received GELF message <{}> to process buffer: {}", (Object)lm.getId(), (Object)lm);
        this.metricRegistry.meter(MetricRegistry.name(metricName, "processedMessages")).mark();
        return lm;
    }
}

