/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.gelf.gelf;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Iterator;
import java.util.Map;
import org.graylog2.inputs.gelf.gelf.GELFProcessor;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.inputs.MessageInput;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GELFParser {
    private static final Logger LOG = LoggerFactory.getLogger(GELFProcessor.class);
    private final MetricRegistry metricRegistry;
    private final ObjectMapper objectMapper;

    public GELFParser(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
    }

    public Message parse(String message, MessageInput sourceInput) {
        String facility;
        long level;
        long line;
        JsonNode json;
        Timer.Context tcx = this.metricRegistry.timer(MetricRegistry.name(sourceInput.getUniqueReadableId(), "gelfParsedTime")).time();
        try {
            json = this.objectMapper.readTree(message);
        }
        catch (Exception e) {
            LOG.error("Could not parse JSON!", e);
            json = null;
        }
        if (json == null) {
            throw new IllegalStateException("JSON is null/could not be parsed (invalid JSON)");
        }
        double messageTimestamp = this.doubleValue(json, "timestamp");
        DateTime timestamp = messageTimestamp <= 0.0 ? Tools.iso8601() : Tools.dateTimeFromDouble(messageTimestamp);
        Message lm = new Message(this.stringValue(json, "short_message"), this.stringValue(json, "host"), timestamp);
        lm.addField("full_message", this.stringValue(json, "full_message"));
        String file = this.stringValue(json, "file");
        if (file != null && !file.isEmpty()) {
            lm.addField("file", file);
        }
        if ((line = this.longValue(json, "line")) > -1L) {
            lm.addField("line", line);
        }
        if ((level = this.longValue(json, "level")) > -1L) {
            lm.addField("level", level);
        }
        if ((facility = this.stringValue(json, "facility")) != null && !facility.isEmpty()) {
            lm.addField("facility", facility);
        }
        Iterator<Map.Entry<String, JsonNode>> fields = json.fields();
        while (fields.hasNext()) {
            Object fieldValue;
            Map.Entry<String, JsonNode> entry2 = fields.next();
            String key = entry2.getKey();
            JsonNode value2 = entry2.getValue();
            if (key.startsWith("_") && key.length() > 1) {
                key = key.substring(1);
            }
            if (key.equals("short_message") || key.equals("host") || lm.getField(key) != null || Message.RESERVED_FIELDS.contains(key)) continue;
            if (value2.isContainerNode()) {
                fieldValue = value2.toString();
            } else if (value2.isFloatingPointNumber()) {
                fieldValue = value2.asDouble();
            } else if (value2.isIntegralNumber()) {
                fieldValue = value2.asLong();
            } else {
                if (value2.isNull()) {
                    LOG.debug("Field [{}] is NULL. Skipping.", (Object)key);
                    continue;
                }
                if (value2.isTextual()) {
                    fieldValue = value2.asText();
                } else {
                    LOG.debug("Field [{}] has unknown value type. Skipping.", (Object)key);
                    continue;
                }
            }
            lm.addField(key, fieldValue);
        }
        tcx.stop();
        return lm;
    }

    private String stringValue(JsonNode json, String fieldName) {
        JsonNode value2;
        if (json != null && (value2 = json.get(fieldName)) != null) {
            return value2.asText();
        }
        return null;
    }

    private long longValue(JsonNode json, String fieldName) {
        JsonNode value2;
        if (json != null && (value2 = json.get(fieldName)) != null) {
            return value2.asLong(-1L);
        }
        return -1L;
    }

    private double doubleValue(JsonNode json, String fieldName) {
        JsonNode value2;
        if (json != null && (value2 = json.get(fieldName)) != null) {
            return value2.asDouble(-1.0);
        }
        return -1.0;
    }
}

