/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.gelf;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import org.graylog2.inputs.gelf.gelf.GELFChunkManager;
import org.graylog2.inputs.gelf.gelf.GELFMessage;
import org.graylog2.inputs.gelf.gelf.GELFProcessor;
import org.graylog2.plugin.buffers.Buffer;
import org.graylog2.plugin.inputs.MessageInput;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.socket.DatagramChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GELFDispatcher
extends SimpleChannelHandler {
    private static final Logger LOG = LoggerFactory.getLogger(GELFDispatcher.class);
    private GELFProcessor processor;
    private final MessageInput sourceInput;
    private final Meter receivedMessages;
    private final Meter dispatchedChunkedMessages;
    private final Meter dispatchedUnchunkedMessages;
    private GELFChunkManager gelfChunkManager;

    public GELFDispatcher(MetricRegistry metricRegistry, GELFChunkManager gelfChunkManager, Buffer processBuffer, MessageInput sourceInput) {
        this.gelfChunkManager = gelfChunkManager;
        this.processor = new GELFProcessor(metricRegistry, processBuffer);
        this.sourceInput = sourceInput;
        this.receivedMessages = metricRegistry.meter(MetricRegistry.name(GELFDispatcher.class, "receivedMessages"));
        this.dispatchedChunkedMessages = metricRegistry.meter(MetricRegistry.name(GELFDispatcher.class, "dispatchedChunkedMessages"));
        this.dispatchedUnchunkedMessages = metricRegistry.meter(MetricRegistry.name(GELFDispatcher.class, "dispatchedUnchunkedMessages"));
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        this.receivedMessages.mark();
        ChannelBuffer buffer = (ChannelBuffer)e.getMessage();
        byte[] readable = new byte[buffer.readableBytes()];
        buffer.toByteBuffer().get(readable, buffer.readerIndex(), buffer.readableBytes());
        GELFMessage msg = new GELFMessage(readable);
        switch (msg.getGELFType()) {
            case CHUNKED: {
                this.dispatchedChunkedMessages.mark();
                this.gelfChunkManager.insert(msg, this.sourceInput);
                break;
            }
            case ZLIB: 
            case GZIP: 
            case UNCOMPRESSED: 
            case UNSUPPORTED: {
                this.dispatchedUnchunkedMessages.mark();
                this.processor.messageReceived(msg, this.sourceInput);
            }
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        LOG.debug("Could not handle GELF message.", e.getCause());
        if (ctx.getChannel() != null && !(ctx.getChannel() instanceof DatagramChannel)) {
            ctx.getChannel().close();
        }
    }
}

