/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.zip.Deflater;
import java.util.zip.GZIPOutputStream;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.Tools;

public class TestHelper {
    public static byte[] zlibCompress(String what) throws UnsupportedEncodingException {
        byte[] input2 = what.getBytes("UTF-8");
        byte[] output2 = new byte[4096];
        Deflater compresser = new Deflater();
        compresser.setInput(input2);
        compresser.finish();
        compresser.deflate(output2);
        return output2;
    }

    public static byte[] gzipCompress(String what) throws IOException {
        ByteArrayInputStream compressMe = new ByteArrayInputStream(what.getBytes("UTF-8"));
        ByteArrayOutputStream compressedMessage = new ByteArrayOutputStream();
        GZIPOutputStream out = new GZIPOutputStream(compressedMessage);
        int c = compressMe.read();
        while (c != -1) {
            out.write(c);
            c = compressMe.read();
        }
        out.close();
        return compressedMessage.toByteArray();
    }

    public static byte[] buildGELFMessageChunk(String id, int seqNum, int seqCnt, byte[] data2) throws Exception {
        if (id.getBytes().length != 8) {
            throw new Exception("IN TEST HELPER!!! YOU WROTE WRONG YOUR TESTS! - id must consist of 8 byte. length is: " + id.getBytes().length);
        }
        byte[] chunkData = new byte[12 + data2.length];
        chunkData[0] = 30;
        chunkData[1] = 15;
        System.arraycopy(id.getBytes(), 0, chunkData, 2, id.getBytes().length);
        chunkData[10] = (byte)seqNum;
        chunkData[11] = (byte)seqCnt;
        System.arraycopy(data2, 0, chunkData, 12, data2.length);
        return chunkData;
    }

    public static String toHex(String arg) throws UnsupportedEncodingException {
        return String.format("%x", new BigInteger(arg.getBytes("UTF-8")));
    }

    public static Message simpleLogMessage() {
        Message m = new Message("bar", "foo", Tools.iso8601());
        return m;
    }
}

