/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs;

import com.google.common.collect.Queues;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.cliffc.high_scale_lib.Counter;
import org.graylog2.inputs.InputCache;
import org.graylog2.inputs.OutputCache;
import org.graylog2.plugin.Message;

public class BasicCache
implements InputCache,
OutputCache {
    private final ConcurrentLinkedQueue<Message> q = Queues.newConcurrentLinkedQueue();
    private final Counter counter = new Counter();

    @Override
    public void add(Message m) {
        this.q.add(m);
        this.counter.increment();
    }

    @Override
    public Message pop() {
        Message m = this.q.poll();
        if (m != null) {
            this.counter.decrement();
            return m;
        }
        return null;
    }

    @Override
    public int size() {
        return this.counter.intValue();
    }

    @Override
    public boolean isEmpty() {
        return this.q.isEmpty();
    }
}

