/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import org.glassfish.jersey.message.internal.TracingLogger;
import org.glassfish.jersey.process.internal.AbstractChainableStage;
import org.glassfish.jersey.process.internal.Inflecting;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.internal.ServerTraceEvent;
import org.glassfish.jersey.server.internal.process.RequestProcessingContext;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.TransformableData;
import org.glassfish.jersey.server.monitoring.RequestEvent;

public class RoutingStage
extends AbstractChainableStage<RequestProcessingContext> {
    private final Router routingRoot;

    public RoutingStage(Router routingRoot) {
        this.routingRoot = routingRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stage.Continuation<RequestProcessingContext> apply(RequestProcessingContext context) {
        ContainerRequest request = context.request();
        context.triggerEvent(RequestEvent.Type.MATCHING_START);
        TracingLogger tracingLogger = TracingLogger.getInstance(request);
        long timestamp = tracingLogger.timestamp(ServerTraceEvent.MATCH_SUMMARY);
        try {
            TransformableData<RequestProcessingContext, ContainerResponse> result2 = this._apply(context, this.routingRoot);
            Stage nextStage = null;
            if (result2.hasInflector()) {
                context.routingContext().setInflector(result2.inflector());
                nextStage = this.getDefaultNext();
            }
            Stage.Continuation<RequestProcessingContext> continuation = Stage.Continuation.of(result2.data(), nextStage);
            return continuation;
        }
        finally {
            tracingLogger.logDuration(ServerTraceEvent.MATCH_SUMMARY, timestamp, new Object[0]);
        }
    }

    private TransformableData<RequestProcessingContext, ContainerResponse> _apply(RequestProcessingContext request, Router router) {
        Router.Continuation continuation = router.apply(request);
        for (Router child : continuation.next()) {
            TransformableData<RequestProcessingContext, ContainerResponse> result2 = this._apply(continuation.requestContext(), child);
            if (!result2.hasInflector()) continue;
            return result2;
        }
        if (router instanceof Inflecting) {
            return TransformableData.of(continuation.requestContext(), ((Inflecting)((Object)router)).inflector());
        }
        return TransformableData.of(continuation.requestContext());
    }
}

