/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import java.util.Collections;
import jersey.repackaged.com.google.common.collect.Lists;
import org.glassfish.jersey.server.internal.process.RequestProcessingContext;

public interface Router {
    public Continuation apply(RequestProcessingContext var1);

    public static interface Builder {
        public Builder child(Router var1);

        public Router build();
    }

    public static final class Continuation {
        private final RequestProcessingContext requestProcessingContext;
        private final Iterable<Router> next;

        public static Continuation of(RequestProcessingContext result2) {
            return new Continuation(result2, null);
        }

        public static Continuation of(RequestProcessingContext result2, Iterable<Router> next2) {
            return new Continuation(result2, next2);
        }

        public static Continuation of(RequestProcessingContext request, Router next2) {
            return new Continuation(request, Lists.newArrayList(next2));
        }

        private Continuation(RequestProcessingContext request, Iterable<Router> next2) {
            this.requestProcessingContext = request;
            this.next = next2 == null ? Collections.emptyList() : next2;
        }

        public RequestProcessingContext requestContext() {
            return this.requestProcessingContext;
        }

        public Iterable<Router> next() {
            return this.next;
        }

        public boolean hasNext() {
            return this.next.iterator().hasNext();
        }
    }
}

