/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import java.util.Collections;
import java.util.List;
import jersey.repackaged.com.google.common.base.Function;
import jersey.repackaged.com.google.common.collect.Lists;
import org.glassfish.hk2.api.Factory;
import org.glassfish.jersey.server.internal.routing.Router;

final class Route<T> {
    private static final Function<Factory<Router>, Router> PROVIDER_TO_ROUTER_TRANSFORMATION = new Function<Factory<Router>, Router>(){

        @Override
        public Router apply(Factory<Router> f2) {
            return f2.provide();
        }
    };
    private final T routingPattern;
    private final List<Factory<Router>> routerProviders;

    static <T> Route<T> of(T routingPattern, List<Factory<Router>> routerProviders) {
        return new Route<T>(routingPattern, routerProviders);
    }

    private Route(T routingPattern, List<Factory<Router>> routerProviders) {
        this.routingPattern = routingPattern;
        this.routerProviders = routerProviders;
    }

    public T routingPattern() {
        return this.routingPattern;
    }

    public List<Router> next() {
        if (this.routerProviders.isEmpty()) {
            return Collections.emptyList();
        }
        return Lists.transform(this.routerProviders, PROVIDER_TO_ROUTER_TRANSFORMATION);
    }
}

