/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.monitoring;

import java.util.Collections;
import java.util.Map;
import jersey.repackaged.com.google.common.collect.Maps;
import org.glassfish.jersey.server.monitoring.ExceptionMapperStatistics;

final class ExceptionMapperStatisticsImpl
implements ExceptionMapperStatistics {
    private final Map<Class<?>, Long> exceptionMapperExecutionCount;
    private final long successfulMappings;
    private final long unsuccessfulMappings;
    private final long totalMappings;

    private ExceptionMapperStatisticsImpl(Map<Class<?>, Long> exceptionMapperExecutionCount, long successfulMappings, long unsuccessfulMappings, long totalMappings) {
        this.exceptionMapperExecutionCount = exceptionMapperExecutionCount;
        this.successfulMappings = successfulMappings;
        this.unsuccessfulMappings = unsuccessfulMappings;
        this.totalMappings = totalMappings;
    }

    @Override
    public Map<Class<?>, Long> getExceptionMapperExecutions() {
        return this.exceptionMapperExecutionCount;
    }

    @Override
    public long getSuccessfulMappings() {
        return this.successfulMappings;
    }

    @Override
    public long getUnsuccessfulMappings() {
        return this.unsuccessfulMappings;
    }

    @Override
    public long getTotalMappings() {
        return this.totalMappings;
    }

    @Override
    public ExceptionMapperStatistics snapshot() {
        return this;
    }

    static class Builder {
        private Map<Class<?>, Long> exceptionMapperExecutionCount = Maps.newHashMap();
        private long successfulMappings;
        private long unsuccessfulMappings;
        private long totalMappings;
        private ExceptionMapperStatisticsImpl cached;

        Builder() {
        }

        void addMapping(boolean success2, int count2) {
            this.cached = null;
            ++this.totalMappings;
            if (success2) {
                this.successfulMappings += (long)count2;
            } else {
                this.unsuccessfulMappings += (long)count2;
            }
        }

        void addExceptionMapperExecution(Class<?> mapper, int count2) {
            this.cached = null;
            Long cnt = this.exceptionMapperExecutionCount.get(mapper);
            cnt = cnt == null ? (long)count2 : cnt + (long)count2;
            this.exceptionMapperExecutionCount.put(mapper, cnt);
        }

        public ExceptionMapperStatisticsImpl build() {
            if (this.cached == null) {
                this.cached = new ExceptionMapperStatisticsImpl(Collections.unmodifiableMap(this.exceptionMapperExecutionCount), this.successfulMappings, this.unsuccessfulMappings, this.totalMappings);
            }
            return this.cached;
        }
    }
}

