/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal;

import java.util.LinkedList;
import javax.ws.rs.core.Application;
import jersey.repackaged.com.google.common.collect.Iterables;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.spi.AbstractContainerLifecycleListener;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;

public final class ConfigHelper {
    private ConfigHelper() {
    }

    public static ContainerLifecycleListener getContainerLifecycleListener(ApplicationHandler applicationHandler) {
        final Iterable<ContainerLifecycleListener> listeners = Iterables.concat(Providers.getAllProviders(applicationHandler.getServiceLocator(), ContainerLifecycleListener.class), new LinkedList<ContainerLifecycleListener>(){
            {
                this.add(new ServiceLocatorShutdownListener());
            }
        });
        return new ContainerLifecycleListener(){

            @Override
            public void onStartup(Container container) {
                for (ContainerLifecycleListener listener : listeners) {
                    listener.onStartup(container);
                }
            }

            @Override
            public void onReload(Container container) {
                for (ContainerLifecycleListener listener : listeners) {
                    listener.onReload(container);
                }
            }

            @Override
            public void onShutdown(Container container) {
                for (ContainerLifecycleListener listener : listeners) {
                    listener.onShutdown(container);
                }
            }
        };
    }

    public static Application getWrappedApplication(Application app) {
        Application wrappedApplication;
        while (app instanceof ResourceConfig && (wrappedApplication = ((ResourceConfig)app).getApplication()) != app) {
            app = wrappedApplication;
        }
        return app;
    }

    private static class ServiceLocatorShutdownListener
    extends AbstractContainerLifecycleListener {
        private ServiceLocatorShutdownListener() {
        }

        @Override
        public void onShutdown(Container container) {
            ApplicationHandler handler = container.getApplicationHandler();
            ServiceLocator locator = handler.getServiceLocator();
            locator.preDestroy(ConfigHelper.getWrappedApplication(handler.getConfiguration()));
            Injections.shutdownLocator(locator);
        }
    }
}

