/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Singleton;
import javax.ws.rs.NameBinding;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import jersey.repackaged.com.google.common.base.Function;
import jersey.repackaged.com.google.common.base.Predicate;
import jersey.repackaged.com.google.common.collect.Collections2;
import jersey.repackaged.com.google.common.collect.Lists;
import jersey.repackaged.com.google.common.collect.Sets;
import jersey.repackaged.com.google.common.util.concurrent.AbstractFuture;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.CommonProperties;
import org.glassfish.jersey.internal.Errors;
import org.glassfish.jersey.internal.ServiceConfigurationError;
import org.glassfish.jersey.internal.ServiceFinder;
import org.glassfish.jersey.internal.Version;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.inject.ProviderBinder;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.message.internal.NullOutputStream;
import org.glassfish.jersey.model.ContractProvider;
import org.glassfish.jersey.model.internal.ComponentBag;
import org.glassfish.jersey.model.internal.RankedComparator;
import org.glassfish.jersey.model.internal.RankedProvider;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.Stages;
import org.glassfish.jersey.server.ContainerFilteringStage;
import org.glassfish.jersey.server.ContainerMessageBodyWorkersInitializer;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.ResourceBag;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.ServerBinder;
import org.glassfish.jersey.server.ServerConfig;
import org.glassfish.jersey.server.ServerProperties;
import org.glassfish.jersey.server.ServerRuntime;
import org.glassfish.jersey.server.internal.ConfigHelper;
import org.glassfish.jersey.server.internal.JerseyRequestTimeoutHandler;
import org.glassfish.jersey.server.internal.JerseyResourceContext;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.ProcessingProviders;
import org.glassfish.jersey.server.internal.monitoring.ApplicationEventImpl;
import org.glassfish.jersey.server.internal.monitoring.CompositeApplicationEventListener;
import org.glassfish.jersey.server.internal.monitoring.MonitoringContainerListener;
import org.glassfish.jersey.server.internal.process.ReferencesInitializer;
import org.glassfish.jersey.server.internal.process.RequestProcessingContext;
import org.glassfish.jersey.server.internal.routing.RoutedInflectorExtractorStage;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.RoutingStage;
import org.glassfish.jersey.server.internal.routing.RuntimeModelBuilder;
import org.glassfish.jersey.server.model.ComponentModelValidator;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.model.ModelValidationException;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceModel;
import org.glassfish.jersey.server.model.internal.ModelErrors;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.spi.ComponentProvider;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;

public final class ApplicationHandler {
    private static final Logger LOGGER = Logger.getLogger(ApplicationHandler.class.getName());
    private static final SecurityContext DEFAULT_SECURITY_CONTEXT = new SecurityContext(){

        @Override
        public boolean isUserInRole(String role) {
            return false;
        }

        @Override
        public boolean isSecure() {
            return false;
        }

        @Override
        public Principal getUserPrincipal() {
            return null;
        }

        @Override
        public String getAuthenticationScheme() {
            return null;
        }
    };
    private final Application application;
    private final ResourceConfig runtimeConfig;
    private final ServiceLocator locator;
    private ServerRuntime runtime;

    public ApplicationHandler() {
        this(new Application());
    }

    public ApplicationHandler(Class<? extends Application> jaxrsApplicationClass) {
        this.locator = Injections.createLocator(new ServerBinder(null), new ApplicationBinder());
        this.locator.setDefaultClassAnalyzerName("JerseyClassAnalyzer");
        this.application = this.createApplication(jaxrsApplicationClass);
        this.runtimeConfig = ResourceConfig.createRuntimeConfig(this.application);
        Errors.processWithException(new Runnable(){

            @Override
            public void run() {
                ApplicationHandler.this.initialize();
            }
        });
    }

    public ApplicationHandler(Application application) {
        this(application, null, null);
    }

    public ApplicationHandler(Application application, Binder customBinder) {
        this(application, customBinder, null);
    }

    public ApplicationHandler(Application application, Binder customBinder, ServiceLocator parent) {
        ResourceConfig rc;
        this.locator = customBinder == null ? Injections.createLocator(parent, new ServerBinder(application.getProperties()), new ApplicationBinder()) : Injections.createLocator(parent, new ServerBinder(application.getProperties()), new ApplicationBinder(), customBinder);
        this.locator.setDefaultClassAnalyzerName("JerseyClassAnalyzer");
        this.application = application;
        if (application instanceof ResourceConfig && (rc = (ResourceConfig)application).getApplicationClass() != null) {
            rc.setApplication(this.createApplication(rc.getApplicationClass()));
        }
        this.runtimeConfig = ResourceConfig.createRuntimeConfig(application);
        Errors.processWithException(new Runnable(){

            @Override
            public void run() {
                ApplicationHandler.this.initialize();
            }
        });
    }

    private Application createApplication(Class<? extends Application> applicationClass) {
        ResourceConfig _rc;
        Class<? extends Application> innerAppClass;
        if (applicationClass == ResourceConfig.class) {
            return new ResourceConfig();
        }
        if (applicationClass == Application.class) {
            return new Application();
        }
        Application app = this.locator.createAndInitialize(applicationClass);
        if (app instanceof ResourceConfig && (innerAppClass = (_rc = (ResourceConfig)app).getApplicationClass()) != null) {
            Application innerApp = this.createApplication(innerAppClass);
            _rc.setApplication(innerApp);
        }
        return app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        ResourceModel resourceModel;
        ProcessingProviders processingProviders;
        ComponentBag componentBag;
        LinkedList<ComponentProvider> componentProviders;
        ResourceBag resourceBag;
        LOGGER.config(LocalizationMessages.INIT_MSG(Version.getBuildId()));
        if (this.application instanceof ResourceConfig) {
            ((ResourceConfig)this.application).lock();
        }
        boolean ignoreValidationErrors = ServerProperties.getValue(this.runtimeConfig.getProperties(), "jersey.config.server.resource.validation.ignoreErrors", Boolean.FALSE, Boolean.class);
        boolean disableValidation = ServerProperties.getValue(this.runtimeConfig.getProperties(), "jersey.config.server.resource.validation.disable", Boolean.FALSE, Boolean.class);
        CompositeApplicationEventListener compositeListener = null;
        Errors.mark();
        try {
            Resource resource;
            if (!CommonProperties.getValue(this.runtimeConfig.getProperties(), RuntimeType.SERVER, "jersey.config.disableAutoDiscovery", Boolean.FALSE, Boolean.class).booleanValue()) {
                this.runtimeConfig.configureAutoDiscoverableProviders(this.locator);
            } else {
                this.runtimeConfig.configureForcedAutoDiscoverableProviders(this.locator);
            }
            this.runtimeConfig.configureMetaProviders(this.locator);
            ResourceBag.Builder resourceBagBuilder = new ResourceBag.Builder();
            for (Resource resource2 : this.runtimeConfig.getResources()) {
                resourceBagBuilder.registerProgrammaticResource(resource2);
            }
            for (Class clazz : this.runtimeConfig.getClasses()) {
                try {
                    resource = Resource.from(clazz, disableValidation);
                    if (resource == null) continue;
                    resourceBagBuilder.registerResource(clazz, resource);
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.warning(ex.getMessage());
                }
            }
            for (Object object : this.runtimeConfig.getSingletons()) {
                try {
                    resource = Resource.from(object.getClass(), disableValidation);
                    if (resource == null) continue;
                    resourceBagBuilder.registerResource(object, resource);
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.warning(ex.getMessage());
                }
            }
            resourceBag = resourceBagBuilder.build();
            this.runtimeConfig.lock();
            componentProviders = new LinkedList<ComponentProvider>();
            for (RankedProvider rankedProvider : this.getRankedComponentProviders()) {
                ComponentProvider provider = (ComponentProvider)rankedProvider.getProvider();
                provider.initialize(this.locator);
                componentProviders.add(provider);
            }
            componentBag = this.runtimeConfig.getComponentBag();
            this.bindProvidersAndResources(componentProviders, componentBag, resourceBag.classes, resourceBag.instances);
            for (ComponentProvider componentProvider : componentProviders) {
                componentProvider.done();
            }
            List<ApplicationEventListener> appEventListeners = this.locator.getAllServices(ApplicationEventListener.class, new Annotation[0]);
            if (!appEventListeners.isEmpty()) {
                compositeListener = new CompositeApplicationEventListener(appEventListeners);
                compositeListener.onEvent(new ApplicationEventImpl(ApplicationEvent.Type.INITIALIZATION_START, this.runtimeConfig, componentBag.getRegistrations(), resourceBag.classes, resourceBag.instances, null));
            }
            processingProviders = this.getProcessingProviders(componentBag);
            GenericType<Ref<ProcessingProviders>> genericType = new GenericType<Ref<ProcessingProviders>>(){};
            Ref refProcessingProvider = (Ref)this.locator.getService(genericType.getType(), new Annotation[0]);
            refProcessingProvider.set(processingProviders);
            resourceModel = new ResourceModel.Builder(resourceBag.getRootResources(), false).build();
            resourceModel = this.processResourceModel(resourceModel);
            if (!disableValidation) {
                ComponentModelValidator validator = new ComponentModelValidator(this.locator);
                validator.validate(resourceModel);
            }
            if (Errors.fatalIssuesFound() && !ignoreValidationErrors) {
                throw new ModelValidationException(LocalizationMessages.RESOURCE_MODEL_VALIDATION_FAILED_AT_INIT(), ModelErrors.getErrorsAsResourceModelIssues(true));
            }
        }
        finally {
            if (ignoreValidationErrors) {
                Errors.logErrors(true);
                Errors.reset();
            } else {
                Errors.unmark();
            }
        }
        this.bindEnhancingResourceClasses(resourceModel, resourceBag, componentProviders);
        JerseyResourceContext jerseyResourceContext = this.locator.getService(JerseyResourceContext.class, new Annotation[0]);
        jerseyResourceContext.setResourceModel(resourceModel);
        RuntimeModelBuilder runtimeModelBuilder = this.locator.getService(RuntimeModelBuilder.class, new Annotation[0]);
        runtimeModelBuilder.setProcessingProviders(processingProviders);
        Router router = runtimeModelBuilder.buildModel(resourceModel.getRuntimeResourceModel(), false);
        ReferencesInitializer referencesInitializer = this.locator.createAndInitialize(ReferencesInitializer.class);
        ContainerFilteringStage preMatchRequestFilteringStage = new ContainerFilteringStage(processingProviders.getPreMatchFilters(), processingProviders.getGlobalResponseFilters());
        RoutingStage routingStage = new RoutingStage(router);
        ContainerFilteringStage resourceFilteringStage = new ContainerFilteringStage(processingProviders.getGlobalRequestFilters(), null);
        RoutedInflectorExtractorStage routedInflectorExtractorStage = new RoutedInflectorExtractorStage();
        Stage<RequestProcessingContext> rootStage = Stages.chain(referencesInitializer).to(this.locator.createAndInitialize(ContainerMessageBodyWorkersInitializer.class)).to(preMatchRequestFilteringStage).to(routingStage).to(resourceFilteringStage).build(routedInflectorExtractorStage);
        this.runtime = this.locator.createAndInitialize(ServerRuntime.Builder.class).build(rootStage, compositeListener, processingProviders);
        for (Object instance : componentBag.getInstances(ComponentBag.EXCLUDE_META_PROVIDERS)) {
            this.locator.inject(instance);
        }
        for (Object instance : resourceBag.instances) {
            this.locator.inject(instance);
        }
        ApplicationHandler.logApplicationInitConfiguration(this.locator, resourceBag, processingProviders);
        if (compositeListener != null) {
            ApplicationEventImpl initFinishedEvent = new ApplicationEventImpl(ApplicationEvent.Type.INITIALIZATION_APP_FINISHED, this.runtimeConfig, componentBag.getRegistrations(), resourceBag.classes, resourceBag.instances, resourceModel);
            compositeListener.onEvent(initFinishedEvent);
            MonitoringContainerListener containerListener = this.locator.getService(MonitoringContainerListener.class, new Annotation[0]);
            containerListener.init(compositeListener, initFinishedEvent);
        }
    }

    private static void logApplicationInitConfiguration(ServiceLocator locator, ResourceBag resourceBag, ProcessingProviders processingProviders) {
        Set<MessageBodyWriter> messageBodyWriters;
        Set<MessageBodyReader> messageBodyReaders;
        if (!LOGGER.isLoggable(Level.CONFIG)) {
            return;
        }
        StringBuilder sb = new StringBuilder(LocalizationMessages.LOGGING_APPLICATION_INITIALIZED()).append('\n');
        List<Resource> rootResourceClasses = resourceBag.getRootResources();
        if (!rootResourceClasses.isEmpty()) {
            sb.append(LocalizationMessages.LOGGING_ROOT_RESOURCE_CLASSES()).append(":");
            for (Resource r : rootResourceClasses) {
                for (Class<?> clazz : r.getHandlerClasses()) {
                    sb.append('\n').append("  ").append(clazz.getName());
                }
            }
        }
        sb.append('\n');
        if (LOGGER.isLoggable(Level.FINE)) {
            messageBodyReaders = Sets.newHashSet(Providers.getAllProviders(locator, MessageBodyReader.class));
            messageBodyWriters = Sets.newHashSet(Providers.getAllProviders(locator, MessageBodyWriter.class));
        } else {
            messageBodyReaders = Providers.getCustomProviders(locator, MessageBodyReader.class);
            messageBodyWriters = Providers.getCustomProviders(locator, MessageBodyWriter.class);
        }
        ApplicationHandler.printProviders(LocalizationMessages.LOGGING_PRE_MATCH_FILTERS(), processingProviders.getPreMatchFilters(), sb);
        ApplicationHandler.printProviders(LocalizationMessages.LOGGING_GLOBAL_REQUEST_FILTERS(), processingProviders.getGlobalRequestFilters(), sb);
        ApplicationHandler.printProviders(LocalizationMessages.LOGGING_GLOBAL_RESPONSE_FILTERS(), processingProviders.getGlobalResponseFilters(), sb);
        ApplicationHandler.printProviders(LocalizationMessages.LOGGING_GLOBAL_READER_INTERCEPTORS(), processingProviders.getGlobalReaderInterceptors(), sb);
        ApplicationHandler.printProviders(LocalizationMessages.LOGGING_GLOBAL_WRITER_INTERCEPTORS(), processingProviders.getGlobalWriterInterceptors(), sb);
        ApplicationHandler.printNameBoundProviders(LocalizationMessages.LOGGING_NAME_BOUND_REQUEST_FILTERS(), processingProviders.getNameBoundRequestFilters(), sb);
        ApplicationHandler.printNameBoundProviders(LocalizationMessages.LOGGING_NAME_BOUND_RESPONSE_FILTERS(), processingProviders.getNameBoundResponseFilters(), sb);
        ApplicationHandler.printNameBoundProviders(LocalizationMessages.LOGGING_NAME_BOUND_READER_INTERCEPTORS(), processingProviders.getNameBoundReaderInterceptors(), sb);
        ApplicationHandler.printNameBoundProviders(LocalizationMessages.LOGGING_NAME_BOUND_WRITER_INTERCEPTORS(), processingProviders.getNameBoundWriterInterceptors(), sb);
        ApplicationHandler.printProviders(LocalizationMessages.LOGGING_DYNAMIC_FEATURES(), processingProviders.getDynamicFeatures(), sb);
        ApplicationHandler.printProviders(LocalizationMessages.LOGGING_MESSAGE_BODY_READERS(), Collections2.transform(messageBodyReaders, new WorkersToStringTransform()), sb);
        ApplicationHandler.printProviders(LocalizationMessages.LOGGING_MESSAGE_BODY_WRITERS(), Collections2.transform(messageBodyWriters, new WorkersToStringTransform()), sb);
        LOGGER.log(Level.CONFIG, sb.toString());
    }

    private static <T> void printNameBoundProviders(String title, Map<Class<? extends Annotation>, List<RankedProvider<T>>> providers, StringBuilder sb) {
        if (!providers.isEmpty()) {
            sb.append(title).append(":").append('\n');
            for (Map.Entry<Class<Annotation>, List<RankedProvider<T>>> entry2 : providers.entrySet()) {
                for (RankedProvider<T> rankedProvider : entry2.getValue()) {
                    sb.append("   ").append(LocalizationMessages.LOGGING_PROVIDER_BOUND(rankedProvider, entry2.getKey())).append('\n');
                }
            }
        }
    }

    private static <T> void printProviders(String title, Iterable<T> providers, StringBuilder sb) {
        Iterator<T> iterator2 = providers.iterator();
        boolean first = true;
        while (iterator2.hasNext()) {
            if (first) {
                sb.append(title).append(":").append('\n');
                first = false;
            }
            T provider = iterator2.next();
            sb.append("   ").append(provider).append('\n');
        }
    }

    private Iterable<RankedProvider<ComponentProvider>> getRankedComponentProviders() throws ServiceConfigurationError {
        boolean enableMetainfServicesLookup;
        LinkedList<RankedProvider<ComponentProvider>> result2 = new LinkedList<RankedProvider<ComponentProvider>>();
        boolean bl = enableMetainfServicesLookup = CommonProperties.getValue(this.application.getProperties(), RuntimeType.SERVER, "jersey.config.disableMetainfServicesLookup", false, Boolean.class) == false;
        if (enableMetainfServicesLookup) {
            for (ComponentProvider provider : ServiceFinder.find(ComponentProvider.class)) {
                result2.add(new RankedProvider<ComponentProvider>(provider));
            }
            Collections.sort(result2, new RankedComparator(RankedComparator.Order.DESCENDING));
        }
        return result2;
    }

    private ProcessingProviders getProcessingProviders(ComponentBag componentBag) {
        Collection<Class<? extends Annotation>> applicationNameBindings = ReflectionHelper.getAnnotationTypes(ConfigHelper.getWrappedApplication(this.runtimeConfig).getClass(), NameBinding.class);
        Iterable<RankedProvider<ContainerResponseFilter>> responseFilters = Providers.getAllRankedProviders(this.locator, ContainerResponseFilter.class);
        MultivaluedHashMap<RankedProvider<ContainerResponseFilter>, Class<? extends Annotation>> nameBoundResponseFiltersInverse = new MultivaluedHashMap<RankedProvider<ContainerResponseFilter>, Class<? extends Annotation>>();
        MultivaluedHashMap<RankedProvider<ContainerRequestFilter>, Class<? extends Annotation>> nameBoundRequestFiltersInverse = new MultivaluedHashMap<RankedProvider<ContainerRequestFilter>, Class<? extends Annotation>>();
        MultivaluedHashMap<RankedProvider<ReaderInterceptor>, Class<? extends Annotation>> nameBoundReaderInterceptorsInverse = new MultivaluedHashMap<RankedProvider<ReaderInterceptor>, Class<? extends Annotation>>();
        MultivaluedHashMap<RankedProvider<WriterInterceptor>, Class<? extends Annotation>> nameBoundWriterInterceptorsInverse = new MultivaluedHashMap<RankedProvider<WriterInterceptor>, Class<? extends Annotation>>();
        MultivaluedMap<Class<? extends Annotation>, RankedProvider<ContainerResponseFilter>> nameBoundResponseFilters = ApplicationHandler.filterNameBound(responseFilters, null, componentBag, applicationNameBindings, nameBoundResponseFiltersInverse);
        Iterable<RankedProvider<ContainerRequestFilter>> requestFilters = Providers.getAllRankedProviders(this.locator, ContainerRequestFilter.class);
        ArrayList<RankedProvider<ContainerRequestFilter>> preMatchFilters = Lists.newArrayList();
        MultivaluedMap<Class<? extends Annotation>, RankedProvider<ContainerRequestFilter>> nameBoundRequestFilters = ApplicationHandler.filterNameBound(requestFilters, preMatchFilters, componentBag, applicationNameBindings, nameBoundRequestFiltersInverse);
        Iterable<RankedProvider<ReaderInterceptor>> readerInterceptors = Providers.getAllRankedProviders(this.locator, ReaderInterceptor.class);
        MultivaluedMap<Class<? extends Annotation>, RankedProvider<ReaderInterceptor>> nameBoundReaderInterceptors = ApplicationHandler.filterNameBound(readerInterceptors, null, componentBag, applicationNameBindings, nameBoundReaderInterceptorsInverse);
        Iterable<RankedProvider<WriterInterceptor>> writerInterceptors = Providers.getAllRankedProviders(this.locator, WriterInterceptor.class);
        MultivaluedMap<Class<? extends Annotation>, RankedProvider<WriterInterceptor>> nameBoundWriterInterceptors = ApplicationHandler.filterNameBound(writerInterceptors, null, componentBag, applicationNameBindings, nameBoundWriterInterceptorsInverse);
        Iterable<DynamicFeature> dynamicFeatures = Providers.getAllProviders(this.locator, DynamicFeature.class);
        return new ProcessingProviders(nameBoundRequestFilters, nameBoundRequestFiltersInverse, nameBoundResponseFilters, nameBoundResponseFiltersInverse, nameBoundReaderInterceptors, nameBoundReaderInterceptorsInverse, nameBoundWriterInterceptors, nameBoundWriterInterceptorsInverse, requestFilters, preMatchFilters, responseFilters, readerInterceptors, writerInterceptors, dynamicFeatures);
    }

    private ResourceModel processResourceModel(ResourceModel resourceModel) {
        Iterable allRankedProviders = Providers.getAllRankedProviders(this.locator, ModelProcessor.class);
        Iterable<ModelProcessor> modelProcessors = Providers.sortRankedProviders(new RankedComparator(), allRankedProviders);
        for (ModelProcessor modelProcessor : modelProcessors) {
            resourceModel = modelProcessor.processResourceModel(resourceModel, this.getConfiguration());
        }
        return resourceModel;
    }

    private void bindEnhancingResourceClasses(ResourceModel resourceModel, ResourceBag resourceBag, Iterable<ComponentProvider> componentProviders) {
        HashSet<Class<Class<?>>> newClasses = Sets.newHashSet();
        HashSet<Object> newInstances = Sets.newHashSet();
        for (Resource res : resourceModel.getRootResources()) {
            newClasses.addAll(res.getHandlerClasses());
            newInstances.addAll(res.getHandlerInstances());
        }
        newClasses.removeAll(resourceBag.classes);
        newInstances.removeAll(resourceBag.instances);
        ComponentBag emptyComponentBag = ComponentBag.newInstance(new Predicate<ContractProvider>(){

            @Override
            public boolean apply(ContractProvider input2) {
                return false;
            }
        });
        this.bindProvidersAndResources(componentProviders, emptyComponentBag, newClasses, newInstances);
    }

    private static <T> MultivaluedMap<Class<? extends Annotation>, RankedProvider<T>> filterNameBound(Iterable<RankedProvider<T>> all, Collection<RankedProvider<ContainerRequestFilter>> preMatching, ComponentBag componentBag, Collection<Class<? extends Annotation>> applicationNameBindings, MultivaluedMap<RankedProvider<T>, Class<? extends Annotation>> inverseNameBoundMap) {
        MultivaluedHashMap<Class<Annotation>, RankedProvider<T>> result2 = new MultivaluedHashMap<Class<Annotation>, RankedProvider<T>>();
        Iterator<RankedProvider<T>> it = all.iterator();
        while (it.hasNext()) {
            boolean nameBound;
            RankedProvider<T> provider = it.next();
            Class<?> providerClass = provider.getProvider().getClass();
            ContractProvider model = componentBag.getModel(providerClass);
            if (model == null) {
                model = ComponentBag.modelFor(providerClass);
            }
            if (preMatching != null && providerClass.getAnnotation(PreMatching.class) != null) {
                it.remove();
                preMatching.add(new RankedProvider<ContainerRequestFilter>((ContainerRequestFilter)provider.getProvider(), model.getPriority(ContainerRequestFilter.class)));
            }
            if ((nameBound = model.isNameBound()) && !applicationNameBindings.isEmpty() && applicationNameBindings.containsAll(model.getNameBindings())) {
                nameBound = false;
            }
            if (!nameBound) continue;
            it.remove();
            for (Class binding : model.getNameBindings()) {
                result2.add(binding, provider);
                inverseNameBoundMap.add(provider, binding);
            }
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private void bindProvidersAndResources(Iterable<ComponentProvider> componentProviders, final ComponentBag componentBag, final Collection<Class<?>> resourceClasses, final Collection<Object> resourceInstances) {
        JerseyResourceContext resourceContext = this.locator.getService(JerseyResourceContext.class, new Annotation[0]);
        DynamicConfiguration dc = Injections.getConfiguration(this.locator);
        final Set<Class<?>> registeredClasses = this.runtimeConfig.getRegisteredClasses();
        Set<Class<?>> classes = Sets.newIdentityHashSet();
        classes.addAll(Sets.filter(componentBag.getClasses(ComponentBag.EXCLUDE_META_PROVIDERS), new Predicate<Class<?>>(){

            @Override
            public boolean apply(Class<?> componentClass) {
                return Providers.checkProviderRuntime(componentClass, componentBag.getModel(componentClass), RuntimeType.SERVER, !registeredClasses.contains(componentClass), resourceClasses.contains(componentClass));
            }
        }));
        classes.addAll(resourceClasses);
        for (Class clazz : classes) {
            ContractProvider contractProvider;
            if (this.bindWithComponentProvider(clazz, contractProvider = componentBag.getModel(clazz), componentProviders)) continue;
            if (resourceClasses.contains(clazz)) {
                void var11_12;
                if (!Resource.isAcceptable(clazz)) {
                    LOGGER.warning(LocalizationMessages.NON_INSTANTIABLE_COMPONENT(clazz));
                    continue;
                }
                if (contractProvider != null && !Providers.checkProviderRuntime(clazz, contractProvider, RuntimeType.SERVER, !registeredClasses.contains(clazz), true)) {
                    Object var11_14 = null;
                }
                resourceContext.unsafeBindResource(clazz, (ContractProvider)var11_12, dc);
                continue;
            }
            ProviderBinder.bindProvider(clazz, contractProvider, dc);
        }
        HashSet<Object> instances = Sets.newHashSet();
        instances.addAll(Sets.filter(componentBag.getInstances(ComponentBag.EXCLUDE_META_PROVIDERS), new Predicate<Object>(){

            @Override
            public boolean apply(Object component) {
                Class<?> componentClass = component.getClass();
                return Providers.checkProviderRuntime(componentClass, componentBag.getModel(componentClass), RuntimeType.SERVER, !registeredClasses.contains(componentClass), resourceInstances.contains(component));
            }
        }));
        instances.addAll(resourceInstances);
        for (Object e : instances) {
            ContractProvider model = componentBag.getModel(e.getClass());
            if (resourceInstances.contains(e)) {
                if (model != null && !Providers.checkProviderRuntime(e.getClass(), model, RuntimeType.SERVER, !registeredClasses.contains(e.getClass()), true)) {
                    model = null;
                }
                resourceContext.unsafeBindResource(e, model, dc);
                continue;
            }
            ProviderBinder.bindProvider(e, model, dc);
        }
        dc.commit();
    }

    private boolean bindWithComponentProvider(Class<?> component, ContractProvider providerModel, Iterable<ComponentProvider> componentProviders) {
        Set<Class<?>> contracts = providerModel == null ? Collections.emptySet() : providerModel.getContracts();
        for (ComponentProvider provider : componentProviders) {
            if (!provider.bind(component, contracts)) continue;
            return true;
        }
        return false;
    }

    public Future<ContainerResponse> apply(ContainerRequest requestContext) {
        return this.apply(requestContext, new NullOutputStream());
    }

    public Future<ContainerResponse> apply(ContainerRequest request, OutputStream outputStream) {
        FutureResponseWriter responseFuture = new FutureResponseWriter(request.getMethod(), outputStream, this.runtime.getBackgroundScheduler());
        if (request.getSecurityContext() == null) {
            request.setSecurityContext(DEFAULT_SECURITY_CONTEXT);
        }
        request.setWriter(responseFuture);
        this.handle(request);
        return responseFuture;
    }

    public void handle(ContainerRequest request) {
        this.runtime.process(request);
    }

    public ServiceLocator getServiceLocator() {
        return this.locator;
    }

    public ResourceConfig getConfiguration() {
        return this.runtimeConfig;
    }

    private static class FutureResponseWriter
    extends AbstractFuture<ContainerResponse>
    implements ContainerResponseWriter {
        private ContainerResponse response = null;
        private final String requestMethodName;
        private final OutputStream outputStream;
        private final JerseyRequestTimeoutHandler requestTimeoutHandler;

        private FutureResponseWriter(String requestMethodName, OutputStream outputStream, ScheduledExecutorService backgroundScheduler) {
            this.requestMethodName = requestMethodName;
            this.outputStream = outputStream;
            this.requestTimeoutHandler = new JerseyRequestTimeoutHandler(this, backgroundScheduler);
        }

        @Override
        public OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse response) {
            this.response = response;
            if (contentLength >= 0L) {
                response.getHeaders().putSingle("Content-Length", Long.toString(contentLength));
            }
            return this.outputStream;
        }

        @Override
        public boolean suspend(long time, TimeUnit unit, ContainerResponseWriter.TimeoutHandler handler) {
            return this.requestTimeoutHandler.suspend(time, unit, handler);
        }

        @Override
        public void setSuspendTimeout(long time, TimeUnit unit) {
            this.requestTimeoutHandler.setSuspendTimeout(time, unit);
        }

        @Override
        public void commit() {
            ContainerResponse current = this.response;
            if (current != null) {
                if ("HEAD".equals(this.requestMethodName) && current.hasEntity()) {
                    current.setEntity(null);
                }
                this.requestTimeoutHandler.close();
                super.set(current);
            }
        }

        @Override
        public void failure(Throwable error) {
            this.requestTimeoutHandler.close();
            super.setException(error);
        }

        @Override
        public boolean enableResponseBuffering() {
            return true;
        }

        @Override
        protected void interruptTask() {
        }
    }

    private static class WorkersToStringTransform<T>
    implements Function<T, String> {
        private WorkersToStringTransform() {
        }

        @Override
        public String apply(T t) {
            if (t != null) {
                return t.getClass().getName();
            }
            return null;
        }
    }

    private class ApplicationBinder
    extends AbstractBinder {
        private ApplicationBinder() {
        }

        @Override
        protected void configure() {
            this.bindFactory(new RuntimeConfigProvider()).to(ServerConfig.class).to(Configuration.class).in(Singleton.class);
            this.bindFactory(new JaxrsApplicationProvider()).to(Application.class).in(Singleton.class);
            this.bind(ApplicationHandler.this).to(ApplicationHandler.class);
        }

        private class RuntimeConfigProvider
        implements Factory<ServerConfig> {
            private RuntimeConfigProvider() {
            }

            @Override
            public ServerConfig provide() {
                return ApplicationHandler.this.runtimeConfig;
            }

            @Override
            public void dispose(ServerConfig instance) {
            }
        }

        private class JaxrsApplicationProvider
        implements Factory<Application> {
            private JaxrsApplicationProvider() {
            }

            @Override
            public Application provide() {
                return ApplicationHandler.this.application;
            }

            @Override
            public void dispose(Application instance) {
            }
        }
    }
}

