/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Singleton;
import javax.ws.rs.core.Link;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.util.Tokenizer;
import org.glassfish.jersey.message.internal.JerseyLink;
import org.glassfish.jersey.message.internal.Utils;
import org.glassfish.jersey.spi.HeaderDelegateProvider;

@Singleton
public class LinkProvider
implements HeaderDelegateProvider<Link> {
    private static final Logger LOGGER = Logger.getLogger(LinkProvider.class.getName());

    @Override
    public boolean supports(Class<?> type) {
        return Link.class.isAssignableFrom(type);
    }

    @Override
    public Link fromString(String value2) throws IllegalArgumentException {
        return LinkProvider.initBuilder(new JerseyLink.Builder(), value2).build(new Object[0]);
    }

    static JerseyLink.Builder initBuilder(JerseyLink.Builder lb, String value2) {
        Utils.throwIllegalArgumentExceptionIfNull(value2, LocalizationMessages.LINK_IS_NULL());
        try {
            int gtIndex;
            value2 = value2.trim();
            if (value2.startsWith("<")) {
                gtIndex = value2.indexOf(62);
                if (gtIndex == -1) {
                    throw new IllegalArgumentException("Missing token > in " + value2);
                }
            } else {
                throw new IllegalArgumentException("Missing starting token < in " + value2);
            }
            lb.uri(value2.substring(1, gtIndex).trim());
            String params = value2.substring(gtIndex + 1).trim();
            if (params != null) {
                StringTokenizer st = new StringTokenizer(params, ";=\"", true);
                while (st.hasMoreTokens()) {
                    LinkProvider.checkToken(st, ";");
                    String n = st.nextToken().trim();
                    LinkProvider.checkToken(st, "=");
                    LinkProvider.checkToken(st, "\"");
                    String v = st.nextToken();
                    LinkProvider.checkToken(st, "\"");
                    lb.param(n, v);
                }
            }
        }
        catch (Throwable e) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "Error parsing link value '" + value2 + "'", e);
            }
            lb = null;
        }
        if (lb == null) {
            throw new IllegalArgumentException("Unable to parse link " + value2);
        }
        return lb;
    }

    private static void checkToken(StringTokenizer st, String expected) throws IllegalArgumentException {
        String token2;
        while ((token2 = st.nextToken().trim()).length() == 0) {
        }
        if (!token2.equals(expected)) {
            throw new IllegalArgumentException("Expected token " + expected + " but found " + token2);
        }
    }

    @Override
    public String toString(Link value2) {
        return LinkProvider.stringfy(value2);
    }

    static String stringfy(Link value2) {
        Utils.throwIllegalArgumentExceptionIfNull(value2, LocalizationMessages.LINK_IS_NULL());
        Map<String, String> map2 = value2.getParams();
        StringBuilder sb = new StringBuilder();
        sb.append('<').append(value2.getUri()).append('>');
        for (Map.Entry<String, String> entry2 : map2.entrySet()) {
            sb.append("; ").append(entry2.getKey()).append("=\"").append(entry2.getValue()).append("\"");
        }
        return sb.toString();
    }

    static List<String> getLinkRelations(String rel) {
        return rel == null ? null : Arrays.asList(Tokenizer.tokenize(rel, "\" "));
    }
}

