/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.regex.Pattern;

public final class Tokenizer {
    public static final String COMMON_DELIMITERS = " ,;\n";

    private Tokenizer() {
    }

    public static String[] tokenize(String[] entries) {
        return Tokenizer.tokenize(entries, COMMON_DELIMITERS);
    }

    public static String[] tokenize(String[] entries, String delimiters) {
        LinkedList<String> tokens = new LinkedList<String>();
        for (String entry2 : entries) {
            if (entry2 == null || entry2.isEmpty() || (entry2 = entry2.trim()).isEmpty()) continue;
            Tokenizer.tokenize(entry2, delimiters, tokens);
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static String[] tokenize(String entry2) {
        return Tokenizer.tokenize(entry2, COMMON_DELIMITERS);
    }

    public static String[] tokenize(String entry2, String delimiters) {
        Collection<String> tokens = Tokenizer.tokenize(entry2, delimiters, new LinkedList<String>());
        return tokens.toArray(new String[tokens.size()]);
    }

    private static Collection<String> tokenize(String entry2, String delimiters, Collection<String> tokens) {
        String[] tokenArray;
        StringBuilder regexpBuilder = new StringBuilder(delimiters.length() * 3);
        regexpBuilder.append('[');
        for (char c : delimiters.toCharArray()) {
            regexpBuilder.append(Pattern.quote(String.valueOf(c)));
        }
        regexpBuilder.append(']');
        for (String token2 : tokenArray = entry2.split(regexpBuilder.toString())) {
            if (token2 == null || token2.isEmpty() || (token2 = token2.trim()).isEmpty()) continue;
            tokens.add(token2);
        }
        return tokens;
    }

    public static String unqote(String entry2) {
        if (entry2 == null || entry2.isEmpty()) {
            return entry2;
        }
        if ((entry2 = entry2.trim()).isEmpty()) {
            return entry2;
        }
        entry2 = entry2.startsWith("\"") ? entry2.substring(1) : entry2;
        return entry2.endsWith("\"") ? entry2.substring(0, entry2.length() - 1) : entry2;
    }
}

