/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.local;

import java.io.IOException;
import java.io.NotSerializableException;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.ThrowableObjectOutputStream;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.HandlesStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.NotSerializableTransportException;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseOptions;
import org.elasticsearch.transport.local.LocalTransport;
import org.elasticsearch.transport.support.TransportStatus;

public class LocalTransportChannel
implements TransportChannel {
    private final LocalTransport sourceTransport;
    private final LocalTransport targetTransport;
    private final String action;
    private final long requestId;
    private final Version version;

    public LocalTransportChannel(LocalTransport sourceTransport, LocalTransport targetTransport, String action, long requestId, Version version) {
        this.sourceTransport = sourceTransport;
        this.targetTransport = targetTransport;
        this.action = action;
        this.requestId = requestId;
        this.version = version;
    }

    @Override
    public String action() {
        return this.action;
    }

    @Override
    public void sendResponse(TransportResponse response) throws IOException {
        this.sendResponse(response, TransportResponseOptions.EMPTY);
    }

    @Override
    public void sendResponse(TransportResponse response, TransportResponseOptions options) throws IOException {
        BytesStreamOutput bStream = new BytesStreamOutput();
        HandlesStreamOutput stream = new HandlesStreamOutput(bStream);
        ((StreamOutput)stream).setVersion(this.version);
        ((StreamOutput)stream).writeLong(this.requestId);
        byte status = 0;
        status = TransportStatus.setResponse(status);
        ((StreamOutput)stream).writeByte(status);
        response.writeTo(stream);
        ((StreamOutput)stream).close();
        final byte[] data2 = bStream.bytes().toBytes();
        this.targetTransport.threadPool().generic().execute(new Runnable(){

            @Override
            public void run() {
                LocalTransportChannel.this.targetTransport.messageReceived(data2, LocalTransportChannel.this.action, LocalTransportChannel.this.sourceTransport, LocalTransportChannel.this.version, null);
            }
        });
    }

    @Override
    public void sendResponse(Throwable error) throws IOException {
        BytesStreamOutput stream = new BytesStreamOutput();
        try {
            this.writeResponseExceptionHeader(stream);
            RemoteTransportException tx = new RemoteTransportException(this.targetTransport.nodeName(), this.targetTransport.boundAddress().boundAddress(), this.action, error);
            ThrowableObjectOutputStream too = new ThrowableObjectOutputStream(stream);
            too.writeObject(tx);
            too.close();
        }
        catch (NotSerializableException e) {
            stream.reset();
            this.writeResponseExceptionHeader(stream);
            RemoteTransportException tx = new RemoteTransportException(this.targetTransport.nodeName(), this.targetTransport.boundAddress().boundAddress(), this.action, new NotSerializableTransportException(error));
            ThrowableObjectOutputStream too = new ThrowableObjectOutputStream(stream);
            too.writeObject(tx);
            too.close();
        }
        final byte[] data2 = stream.bytes().toBytes();
        this.targetTransport.threadPool().generic().execute(new Runnable(){

            @Override
            public void run() {
                LocalTransportChannel.this.targetTransport.messageReceived(data2, LocalTransportChannel.this.action, LocalTransportChannel.this.sourceTransport, LocalTransportChannel.this.version, null);
            }
        });
    }

    private void writeResponseExceptionHeader(BytesStreamOutput stream) throws IOException {
        stream.writeLong(this.requestId);
        byte status = 0;
        status = TransportStatus.setResponse(status);
        status = TransportStatus.setError(status);
        stream.writeByte(status);
    }
}

