/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;

public abstract class TransportResponse
implements Streamable {
    private Map<String, Object> headers;

    protected TransportResponse() {
    }

    protected TransportResponse(TransportResponse request) {
        if (request.getHeaders() != null) {
            this.headers = new HashMap<String, Object>(request.getHeaders());
        }
    }

    public final TransportResponse putHeader(String key, Object value2) {
        if (this.headers == null) {
            this.headers = Maps.newHashMap();
        }
        this.headers.put(key, value2);
        return this;
    }

    public final <V> V getHeader(String key) {
        if (this.headers == null) {
            return null;
        }
        return (V)this.headers.get(key);
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            this.headers = in.readMap();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.headers == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeMap(this.headers);
        }
    }

    public static class Empty
    extends TransportResponse {
        public static final Empty INSTANCE = new Empty();

        public Empty() {
        }

        public Empty(TransportResponse request) {
            super(request);
        }
    }
}

