/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.threadpool;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.threadpool.ThreadPool;

public class ThreadPoolInfo
implements Streamable,
Iterable<ThreadPool.Info>,
ToXContent {
    private List<ThreadPool.Info> infos;

    ThreadPoolInfo() {
    }

    public ThreadPoolInfo(List<ThreadPool.Info> infos) {
        this.infos = infos;
    }

    @Override
    public Iterator<ThreadPool.Info> iterator() {
        return this.infos.iterator();
    }

    public static ThreadPoolInfo readThreadPoolInfo(StreamInput in) throws IOException {
        ThreadPoolInfo info = new ThreadPoolInfo();
        info.readFrom(in);
        return info;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int size2 = in.readVInt();
        this.infos = new ArrayList<ThreadPool.Info>(size2);
        for (int i = 0; i < size2; ++i) {
            ThreadPool.Info info = new ThreadPool.Info();
            info.readFrom(in);
            this.infos.add(info);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.infos.size());
        for (ThreadPool.Info info : this.infos) {
            info.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.THREAD_POOL);
        for (ThreadPool.Info info : this.infos) {
            info.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString THREAD_POOL = new XContentBuilderString("thread_pool");

        Fields() {
        }
    }
}

