/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.term;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.suggest.SuggestBuilder;

public class TermSuggestionBuilder
extends SuggestBuilder.SuggestionBuilder<TermSuggestionBuilder> {
    private String suggestMode;
    private Float accuracy;
    private String sort;
    private String stringDistance;
    private Integer maxEdits;
    private Integer maxInspections;
    private Float maxTermFreq;
    private Integer prefixLength;
    private Integer minWordLength;
    private Float minDocFreq;

    public TermSuggestionBuilder(String name) {
        super(name, "term");
    }

    public TermSuggestionBuilder suggestMode(String suggestMode) {
        this.suggestMode = suggestMode;
        return this;
    }

    public TermSuggestionBuilder setAccuracy(float accuracy) {
        this.accuracy = Float.valueOf(accuracy);
        return this;
    }

    public TermSuggestionBuilder sort(String sort2) {
        this.sort = sort2;
        return this;
    }

    public TermSuggestionBuilder stringDistance(String stringDistance) {
        this.stringDistance = stringDistance;
        return this;
    }

    public TermSuggestionBuilder maxEdits(Integer maxEdits) {
        this.maxEdits = maxEdits;
        return this;
    }

    public TermSuggestionBuilder maxInspections(Integer maxInspections) {
        this.maxInspections = maxInspections;
        return this;
    }

    public TermSuggestionBuilder maxTermFreq(float maxTermFreq) {
        this.maxTermFreq = Float.valueOf(maxTermFreq);
        return this;
    }

    public TermSuggestionBuilder prefixLength(int prefixLength) {
        this.prefixLength = prefixLength;
        return this;
    }

    public TermSuggestionBuilder minWordLength(int minWordLength) {
        this.minWordLength = minWordLength;
        return this;
    }

    public TermSuggestionBuilder minDocFreq(float minDocFreq) {
        this.minDocFreq = Float.valueOf(minDocFreq);
        return this;
    }

    @Override
    public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.suggestMode != null) {
            builder.field("suggest_mode", this.suggestMode);
        }
        if (this.accuracy != null) {
            builder.field("accuracy", this.accuracy);
        }
        if (this.sort != null) {
            builder.field("sort", this.sort);
        }
        if (this.stringDistance != null) {
            builder.field("string_distance", this.stringDistance);
        }
        if (this.maxEdits != null) {
            builder.field("max_edits", this.maxEdits);
        }
        if (this.maxInspections != null) {
            builder.field("max_inspections", this.maxInspections);
        }
        if (this.maxTermFreq != null) {
            builder.field("max_term_freq", this.maxTermFreq);
        }
        if (this.prefixLength != null) {
            builder.field("prefix_len", this.prefixLength);
        }
        if (this.minWordLength != null) {
            builder.field("min_word_len", this.minWordLength);
        }
        if (this.minDocFreq != null) {
            builder.field("min_doc_freq", this.minDocFreq);
        }
        return builder;
    }
}

