/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.term;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.spell.DirectSpellChecker;
import org.apache.lucene.search.spell.SuggestWord;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.text.BytesText;
import org.elasticsearch.common.text.StringText;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.search.suggest.SuggestContextParser;
import org.elasticsearch.search.suggest.SuggestUtils;
import org.elasticsearch.search.suggest.Suggester;
import org.elasticsearch.search.suggest.SuggestionSearchContext;
import org.elasticsearch.search.suggest.term.TermSuggestParser;
import org.elasticsearch.search.suggest.term.TermSuggestion;
import org.elasticsearch.search.suggest.term.TermSuggestionContext;

public final class TermSuggester
extends Suggester<TermSuggestionContext> {
    public TermSuggestion innerExecute(String name, TermSuggestionContext suggestion, IndexReader indexReader, CharsRef spare) throws IOException {
        DirectSpellChecker directSpellChecker = SuggestUtils.getDirectSpellChecker(suggestion.getDirectSpellCheckerSettings());
        TermSuggestion response = new TermSuggestion(name, suggestion.getSize(), suggestion.getDirectSpellCheckerSettings().sort());
        List<Token> tokens = this.queryTerms(suggestion, spare);
        for (Token token2 : tokens) {
            SuggestWord[] suggestedWords = directSpellChecker.suggestSimilar(token2.term, suggestion.getShardSize(), indexReader, suggestion.getDirectSpellCheckerSettings().suggestMode());
            BytesText key = new BytesText(new BytesArray(token2.term.bytes()));
            TermSuggestion.Entry resultEntry = new TermSuggestion.Entry(key, token2.startOffset, token2.endOffset - token2.startOffset);
            for (SuggestWord suggestWord : suggestedWords) {
                StringText word = new StringText(suggestWord.string);
                resultEntry.addOption(new TermSuggestion.Entry.Option((Text)word, suggestWord.freq, suggestWord.score));
            }
            response.addTerm(resultEntry);
        }
        return response;
    }

    @Override
    public String[] names() {
        return new String[]{"term"};
    }

    @Override
    public SuggestContextParser getContextParser() {
        return new TermSuggestParser();
    }

    private List<Token> queryTerms(SuggestionSearchContext.SuggestionContext suggestion, CharsRef spare) throws IOException {
        final ArrayList<Token> result2 = new ArrayList<Token>();
        final String field2 = suggestion.getField();
        SuggestUtils.analyze(suggestion.getAnalyzer(), suggestion.getText(), field2, new SuggestUtils.TokenConsumer(){

            @Override
            public void nextToken() {
                Term term = new Term(field2, BytesRef.deepCopyOf(this.fillBytesRef(new BytesRef())));
                result2.add(new Token(term, this.offsetAttr.startOffset(), this.offsetAttr.endOffset()));
            }
        }, spare);
        return result2;
    }

    private static class Token {
        public final Term term;
        public final int startOffset;
        public final int endOffset;

        private Token(Term term, int startOffset, int endOffset) {
            this.term = term;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }
    }
}

