/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.phrase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.spell.DirectSpellChecker;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.common.text.StringText;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.SuggestContextParser;
import org.elasticsearch.search.suggest.SuggestUtils;
import org.elasticsearch.search.suggest.Suggester;
import org.elasticsearch.search.suggest.phrase.CandidateGenerator;
import org.elasticsearch.search.suggest.phrase.Correction;
import org.elasticsearch.search.suggest.phrase.DirectCandidateGenerator;
import org.elasticsearch.search.suggest.phrase.MultiCandidateGeneratorWrapper;
import org.elasticsearch.search.suggest.phrase.NoisyChannelSpellChecker;
import org.elasticsearch.search.suggest.phrase.PhraseSuggestParser;
import org.elasticsearch.search.suggest.phrase.PhraseSuggestion;
import org.elasticsearch.search.suggest.phrase.PhraseSuggestionContext;
import org.elasticsearch.search.suggest.phrase.WordScorer;

public final class PhraseSuggester
extends Suggester<PhraseSuggestionContext> {
    private final BytesRef SEPARATOR = new BytesRef(" ");

    @Override
    public Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>> innerExecute(String name, PhraseSuggestionContext suggestion, IndexReader indexReader, CharsRef spare) throws IOException {
        double realWordErrorLikelihood = suggestion.realworldErrorLikelyhood().floatValue();
        PhraseSuggestion response = new PhraseSuggestion(name, suggestion.getSize());
        List<PhraseSuggestionContext.DirectCandidateGenerator> generators = suggestion.generators();
        int numGenerators = generators.size();
        ArrayList<DirectCandidateGenerator> gens = new ArrayList<DirectCandidateGenerator>(generators.size());
        for (int i = 0; i < numGenerators; ++i) {
            PhraseSuggestionContext.DirectCandidateGenerator generator = generators.get(i);
            DirectSpellChecker directSpellChecker = SuggestUtils.getDirectSpellChecker(generator);
            Terms terms = MultiFields.getTerms(indexReader, generator.field());
            if (terms == null) continue;
            gens.add(new DirectCandidateGenerator(directSpellChecker, generator.field(), generator.suggestMode(), indexReader, realWordErrorLikelihood, generator.size(), generator.preFilter(), generator.postFilter(), terms));
        }
        String suggestField = suggestion.getField();
        Terms suggestTerms = MultiFields.getTerms(indexReader, suggestField);
        if (gens.size() > 0 && suggestTerms != null) {
            NoisyChannelSpellChecker checker = new NoisyChannelSpellChecker(realWordErrorLikelihood, suggestion.getRequireUnigram(), suggestion.getTokenLimit());
            BytesRef separator = suggestion.separator();
            TokenStream stream = checker.tokenStream(suggestion.getAnalyzer(), suggestion.getText(), spare, suggestion.getField());
            WordScorer wordScorer = suggestion.model().newScorer(indexReader, suggestTerms, suggestField, realWordErrorLikelihood, separator);
            NoisyChannelSpellChecker.Result checkerResult = checker.getCorrections(stream, new MultiCandidateGeneratorWrapper(suggestion.getShardSize(), gens.toArray(new CandidateGenerator[gens.size()])), suggestion.maxErrors(), suggestion.getShardSize(), indexReader, wordScorer, separator, suggestion.confidence(), suggestion.gramSize());
            PhraseSuggestion.Entry resultEntry = this.buildResultEntry(suggestion, spare, checkerResult.cutoffScore);
            response.addTerm(resultEntry);
            BytesRef byteSpare = new BytesRef();
            for (Correction correction : checkerResult.corrections) {
                UnicodeUtil.UTF8toUTF16(correction.join(this.SEPARATOR, byteSpare, null, null), spare);
                StringText phrase2 = new StringText(spare.toString());
                StringText highlighted = null;
                if (suggestion.getPreTag() != null) {
                    UnicodeUtil.UTF8toUTF16(correction.join(this.SEPARATOR, byteSpare, suggestion.getPreTag(), suggestion.getPostTag()), spare);
                    highlighted = new StringText(spare.toString());
                }
                resultEntry.addOption(new Suggest.Suggestion.Entry.Option(phrase2, highlighted, (float)correction.score));
            }
        } else {
            response.addTerm(this.buildResultEntry(suggestion, spare, Double.MIN_VALUE));
        }
        return response;
    }

    private PhraseSuggestion.Entry buildResultEntry(PhraseSuggestionContext suggestion, CharsRef spare, double cutoffScore) {
        UnicodeUtil.UTF8toUTF16(suggestion.getText(), spare);
        return new PhraseSuggestion.Entry(new StringText(spare.toString()), 0, spare.length, cutoffScore);
    }

    @Override
    public String[] names() {
        return new String[]{"phrase"};
    }

    @Override
    public SuggestContextParser getContextParser() {
        return new PhraseSuggestParser();
    }
}

