/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.phrase;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.ShingleTokenFilterFactory;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.search.suggest.SuggestContextParser;
import org.elasticsearch.search.suggest.SuggestUtils;
import org.elasticsearch.search.suggest.Suggester;
import org.elasticsearch.search.suggest.SuggestionSearchContext;
import org.elasticsearch.search.suggest.phrase.LaplaceScorer;
import org.elasticsearch.search.suggest.phrase.LinearInterpoatingScorer;
import org.elasticsearch.search.suggest.phrase.PhraseSuggester;
import org.elasticsearch.search.suggest.phrase.PhraseSuggestionContext;
import org.elasticsearch.search.suggest.phrase.StupidBackoffScorer;
import org.elasticsearch.search.suggest.phrase.WordScorer;

public final class PhraseSuggestParser
implements SuggestContextParser {
    private final PhraseSuggester suggester = new PhraseSuggester();

    @Override
    public SuggestionSearchContext.SuggestionContext parse(XContentParser parser, MapperService mapperService) throws IOException {
        XContentParser.Token token2;
        PhraseSuggestionContext suggestion = new PhraseSuggestionContext((Suggester<? extends PhraseSuggestionContext>)this.suggester);
        String fieldName = null;
        boolean gramSizeSet = false;
        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token2 == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                continue;
            }
            if (token2.isValue()) {
                if (SuggestUtils.parseSuggestContext(parser, mapperService, fieldName, suggestion)) continue;
                if ("real_word_error_likelihood".equals(fieldName) || "realWorldErrorLikelihood".equals(fieldName)) {
                    suggestion.setRealWordErrorLikelihood(Float.valueOf(parser.floatValue()));
                    if (!((double)suggestion.realworldErrorLikelyhood().floatValue() <= 0.0)) continue;
                    throw new ElasticSearchIllegalArgumentException("real_word_error_likelihood must be > 0.0");
                }
                if ("confidence".equals(fieldName)) {
                    suggestion.setConfidence(parser.floatValue());
                    if (!((double)suggestion.confidence() < 0.0)) continue;
                    throw new ElasticSearchIllegalArgumentException("confidence must be >= 0.0");
                }
                if ("separator".equals(fieldName)) {
                    suggestion.setSeparator(new BytesRef(parser.text()));
                    continue;
                }
                if ("max_errors".equals(fieldName) || "maxErrors".equals(fieldName)) {
                    suggestion.setMaxErrors(Float.valueOf(parser.floatValue()));
                    if (!((double)suggestion.maxErrors() <= 0.0)) continue;
                    throw new ElasticSearchIllegalArgumentException("max_error must be > 0.0");
                }
                if ("gram_size".equals(fieldName) || "gramSize".equals(fieldName)) {
                    suggestion.setGramSize(parser.intValue());
                    if (suggestion.gramSize() < 1) {
                        throw new ElasticSearchIllegalArgumentException("gram_size must be >= 1");
                    }
                    gramSizeSet = true;
                    continue;
                }
                if ("force_unigrams".equals(fieldName) || "forceUnigrams".equals(fieldName)) {
                    suggestion.setRequireUnigram(parser.booleanValue());
                    continue;
                }
                if ("token_limit".equals(fieldName) || "tokenLimit".equals(fieldName)) {
                    int tokenLimit = parser.intValue();
                    if (tokenLimit <= 0) {
                        throw new ElasticSearchIllegalArgumentException("token_limit must be >= 1");
                    }
                    suggestion.setTokenLimit(tokenLimit);
                    continue;
                }
                throw new ElasticSearchIllegalArgumentException("suggester[phrase] doesn't support field [" + fieldName + "]");
            }
            if (token2 == XContentParser.Token.START_ARRAY) {
                if ("direct_generator".equals(fieldName) || "directGenerator".equals(fieldName)) {
                    while ((token2 = parser.nextToken()) == XContentParser.Token.START_OBJECT) {
                        PhraseSuggestionContext.DirectCandidateGenerator generator = new PhraseSuggestionContext.DirectCandidateGenerator();
                        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token2 == XContentParser.Token.FIELD_NAME) {
                                fieldName = parser.currentName();
                            }
                            if (!token2.isValue()) continue;
                            this.parseCandidateGenerator(parser, mapperService, fieldName, generator);
                        }
                        this.verifyGenerator(generator);
                        suggestion.addGenerator(generator);
                    }
                    continue;
                }
                throw new ElasticSearchIllegalArgumentException("suggester[phrase]  doesn't support array field [" + fieldName + "]");
            }
            if (token2 == XContentParser.Token.START_OBJECT) {
                if ("smoothing".equals(fieldName)) {
                    this.parseSmoothingModel(parser, suggestion, fieldName);
                    continue;
                }
                if ("highlight".equals(fieldName)) {
                    while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token2 == XContentParser.Token.FIELD_NAME) {
                            fieldName = parser.currentName();
                            continue;
                        }
                        if (!token2.isValue()) continue;
                        if ("pre_tag".equals(fieldName) || "preTag".equals(fieldName)) {
                            suggestion.setPreTag(parser.bytes());
                            continue;
                        }
                        if ("post_tag".equals(fieldName) || "postTag".equals(fieldName)) {
                            suggestion.setPostTag(parser.bytes());
                            continue;
                        }
                        throw new ElasticSearchIllegalArgumentException("suggester[phrase][highlight] doesn't support field [" + fieldName + "]");
                    }
                    continue;
                }
                throw new ElasticSearchIllegalArgumentException("suggester[phrase]  doesn't support array field [" + fieldName + "]");
            }
            throw new ElasticSearchIllegalArgumentException("suggester[phrase] doesn't support field [" + fieldName + "]");
        }
        if (suggestion.getField() == null) {
            throw new ElasticSearchIllegalArgumentException("The required field option is missing");
        }
        if (mapperService.smartNameFieldMapper(suggestion.getField()) == null) {
            throw new ElasticSearchIllegalArgumentException("No mapping found for field [" + suggestion.getField() + "]");
        }
        if (suggestion.model() == null) {
            suggestion.setModel(StupidBackoffScorer.FACTORY);
        }
        if (!gramSizeSet || suggestion.generators().isEmpty()) {
            ShingleTokenFilterFactory.Factory shingleFilterFactory = SuggestUtils.getShingleFilterFactory(suggestion.getAnalyzer() == null ? mapperService.fieldSearchAnalyzer(suggestion.getField()) : suggestion.getAnalyzer());
            if (!gramSizeSet && shingleFilterFactory != null) {
                suggestion.setGramSize(shingleFilterFactory.getMaxShingleSize());
                if (suggestion.getAnalyzer() == null && shingleFilterFactory.getMinShingleSize() > 1 && !shingleFilterFactory.getOutputUnigrams()) {
                    throw new ElasticSearchIllegalArgumentException("The default analyzer for field: [" + suggestion.getField() + "] doesn't emit unigrams. If this is intentional try to set the analyzer explicitly");
                }
            }
            if (suggestion.generators().isEmpty()) {
                if (shingleFilterFactory != null && shingleFilterFactory.getMinShingleSize() > 1 && !shingleFilterFactory.getOutputUnigrams() && suggestion.getRequireUnigram()) {
                    throw new ElasticSearchIllegalArgumentException("The default candidate generator for phrase suggest can't operate on field: [" + suggestion.getField() + "] since it doesn't emit unigrams. If this is intentional try to set the candidate generator field explicitly");
                }
                PhraseSuggestionContext.DirectCandidateGenerator generator = new PhraseSuggestionContext.DirectCandidateGenerator();
                generator.setField(suggestion.getField());
                suggestion.addGenerator(generator);
            }
        }
        return suggestion;
    }

    public void parseSmoothingModel(XContentParser parser, PhraseSuggestionContext suggestion, String fieldName) throws IOException {
        XContentParser.Token token2;
        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token2 != XContentParser.Token.FIELD_NAME) continue;
            fieldName = parser.currentName();
            if ("linear".equals(fieldName)) {
                this.ensureNoSmoothing(suggestion);
                final double[] lambdas = new double[3];
                while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token2 == XContentParser.Token.FIELD_NAME) {
                        fieldName = parser.currentName();
                    }
                    if (!token2.isValue()) continue;
                    if ("trigram_lambda".equals(fieldName) || "trigramLambda".equals(fieldName)) {
                        lambdas[0] = parser.doubleValue();
                        if (!(lambdas[0] < 0.0)) continue;
                        throw new ElasticSearchIllegalArgumentException("trigram_lambda must be positive");
                    }
                    if ("bigram_lambda".equals(fieldName) || "bigramLambda".equals(fieldName)) {
                        lambdas[1] = parser.doubleValue();
                        if (!(lambdas[1] < 0.0)) continue;
                        throw new ElasticSearchIllegalArgumentException("bigram_lambda must be positive");
                    }
                    if ("unigram_lambda".equals(fieldName) || "unigramLambda".equals(fieldName)) {
                        lambdas[2] = parser.doubleValue();
                        if (!(lambdas[2] < 0.0)) continue;
                        throw new ElasticSearchIllegalArgumentException("unigram_lambda must be positive");
                    }
                    throw new ElasticSearchIllegalArgumentException("suggester[phrase][smoothing][linear] doesn't support field [" + fieldName + "]");
                }
                double sum2 = 0.0;
                for (int i = 0; i < lambdas.length; ++i) {
                    sum2 += lambdas[i];
                }
                if (Math.abs(sum2 - 1.0) > 0.001) {
                    throw new ElasticSearchIllegalArgumentException("linear smoothing lambdas must sum to 1");
                }
                suggestion.setModel(new WordScorer.WordScorerFactory(){

                    @Override
                    public WordScorer newScorer(IndexReader reader, Terms terms, String field2, double realWordLikelyhood, BytesRef separator) throws IOException {
                        return new LinearInterpoatingScorer(reader, terms, field2, realWordLikelyhood, separator, lambdas[0], lambdas[1], lambdas[2]);
                    }
                });
                continue;
            }
            if ("laplace".equals(fieldName)) {
                this.ensureNoSmoothing(suggestion);
                double theAlpha = 0.5;
                while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token2 == XContentParser.Token.FIELD_NAME) {
                        fieldName = parser.currentName();
                    }
                    if (!token2.isValue() || !"alpha".equals(fieldName)) continue;
                    theAlpha = parser.doubleValue();
                }
                final double alpha = theAlpha;
                suggestion.setModel(new WordScorer.WordScorerFactory(){

                    @Override
                    public WordScorer newScorer(IndexReader reader, Terms terms, String field2, double realWordLikelyhood, BytesRef separator) throws IOException {
                        return new LaplaceScorer(reader, terms, field2, realWordLikelyhood, separator, alpha);
                    }
                });
                continue;
            }
            if ("stupid_backoff".equals(fieldName) || "stupidBackoff".equals(fieldName)) {
                this.ensureNoSmoothing(suggestion);
                double theDiscount = 0.4;
                while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token2 == XContentParser.Token.FIELD_NAME) {
                        fieldName = parser.currentName();
                    }
                    if (!token2.isValue() || !"discount".equals(fieldName)) continue;
                    theDiscount = parser.doubleValue();
                }
                final double discount = theDiscount;
                suggestion.setModel(new WordScorer.WordScorerFactory(){

                    @Override
                    public WordScorer newScorer(IndexReader reader, Terms terms, String field2, double realWordLikelyhood, BytesRef separator) throws IOException {
                        return new StupidBackoffScorer(reader, terms, field2, realWordLikelyhood, separator, discount);
                    }
                });
                continue;
            }
            throw new ElasticSearchIllegalArgumentException("suggester[phrase] doesn't support object field [" + fieldName + "]");
        }
    }

    private void ensureNoSmoothing(PhraseSuggestionContext suggestion) {
        if (suggestion.model() != null) {
            throw new ElasticSearchIllegalArgumentException("only one smoothing model supported");
        }
    }

    private void verifyGenerator(PhraseSuggestionContext.DirectCandidateGenerator suggestion) {
        if (suggestion.field() == null) {
            throw new ElasticSearchIllegalArgumentException("The required field option is missing");
        }
    }

    private void parseCandidateGenerator(XContentParser parser, MapperService mapperService, String fieldName, PhraseSuggestionContext.DirectCandidateGenerator generator) throws IOException {
        if (!SuggestUtils.parseDirectSpellcheckerSettings(parser, fieldName, generator)) {
            if ("field".equals(fieldName)) {
                generator.setField(parser.text());
                if (mapperService.smartNameFieldMapper(generator.field()) == null) {
                    throw new ElasticSearchIllegalArgumentException("No mapping found for field [" + generator.field() + "]");
                }
            } else if ("size".equals(fieldName)) {
                generator.size(parser.intValue());
            } else if ("pre_filter".equals(fieldName) || "preFilter".equals(fieldName)) {
                String analyzerName = parser.text();
                NamedAnalyzer analyzer = mapperService.analysisService().analyzer(analyzerName);
                if (analyzer == null) {
                    throw new ElasticSearchIllegalArgumentException("Analyzer [" + analyzerName + "] doesn't exists");
                }
                generator.preFilter(analyzer);
            } else if ("post_filter".equals(fieldName) || "postFilter".equals(fieldName)) {
                String analyzerName = parser.text();
                NamedAnalyzer analyzer = mapperService.analysisService().analyzer(analyzerName);
                if (analyzer == null) {
                    throw new ElasticSearchIllegalArgumentException("Analyzer [" + analyzerName + "] doesn't exists");
                }
                generator.postFilter(analyzer);
            } else {
                throw new ElasticSearchIllegalArgumentException("CandidateGenerator doesn't support [" + fieldName + "]");
            }
        }
    }
}

