/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.phrase;

import java.util.Arrays;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.search.suggest.SuggestUtils;
import org.elasticsearch.search.suggest.phrase.DirectCandidateGenerator;

public final class Correction {
    public static final Correction[] EMPTY = new Correction[0];
    public double score;
    public final DirectCandidateGenerator.Candidate[] candidates;

    public Correction(double score, DirectCandidateGenerator.Candidate[] candidates) {
        this.score = score;
        this.candidates = candidates;
    }

    public String toString() {
        return "Correction [score=" + this.score + ", candidates=" + Arrays.toString(this.candidates) + "]";
    }

    public BytesRef join(BytesRef separator) {
        return this.join(separator, null, null);
    }

    public BytesRef join(BytesRef separator, BytesRef preTag, BytesRef postTag) {
        return this.join(separator, new BytesRef(), preTag, postTag);
    }

    public BytesRef join(BytesRef separator, BytesRef result2, BytesRef preTag, BytesRef postTag) {
        BytesRef[] toJoin = new BytesRef[this.candidates.length];
        int len = separator.length * this.candidates.length - 1;
        for (int i = 0; i < toJoin.length; ++i) {
            DirectCandidateGenerator.Candidate candidate = this.candidates[i];
            if (preTag == null || candidate.userInput) {
                toJoin[i] = candidate.term;
            } else {
                int maxLen = preTag.length + postTag.length + candidate.term.length;
                BytesRef highlighted = new BytesRef(maxLen);
                if (i == 0 || this.candidates[i - 1].userInput) {
                    highlighted.append(preTag);
                }
                highlighted.append(candidate.term);
                if (toJoin.length == i + 1 || this.candidates[i + 1].userInput) {
                    highlighted.append(postTag);
                }
                toJoin[i] = highlighted;
            }
            len += toJoin[i].length;
        }
        result2.offset = 0;
        result2.grow(len);
        return SuggestUtils.joinPreAllocated(separator, result2, toJoin);
    }
}

