/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.completion;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.suggest.SuggestBuilder;

public class CompletionSuggestionFuzzyBuilder
extends SuggestBuilder.SuggestionBuilder<CompletionSuggestionFuzzyBuilder> {
    private int fuzzyEditDistance = 1;
    private boolean fuzzyTranspositions = true;
    private int fuzzyMinLength = 3;
    private int fuzzyPrefixLength = 1;
    private boolean unicodeAware = false;

    public CompletionSuggestionFuzzyBuilder(String name) {
        super(name, "completion");
    }

    public int getFuzzyEditDistance() {
        return this.fuzzyEditDistance;
    }

    public CompletionSuggestionFuzzyBuilder setFuzzyEditDistance(int fuzzyEditDistance) {
        this.fuzzyEditDistance = fuzzyEditDistance;
        return this;
    }

    public boolean isFuzzyTranspositions() {
        return this.fuzzyTranspositions;
    }

    public CompletionSuggestionFuzzyBuilder setFuzzyTranspositions(boolean fuzzyTranspositions) {
        this.fuzzyTranspositions = fuzzyTranspositions;
        return this;
    }

    public int getFuzzyMinLength() {
        return this.fuzzyMinLength;
    }

    public CompletionSuggestionFuzzyBuilder setFuzzyMinLength(int fuzzyMinLength) {
        this.fuzzyMinLength = fuzzyMinLength;
        return this;
    }

    public int getFuzzyPrefixLength() {
        return this.fuzzyPrefixLength;
    }

    public CompletionSuggestionFuzzyBuilder setFuzzyPrefixLength(int fuzzyPrefixLength) {
        this.fuzzyPrefixLength = fuzzyPrefixLength;
        return this;
    }

    public boolean isUnicodeAware() {
        return this.unicodeAware;
    }

    public CompletionSuggestionFuzzyBuilder setUnicodeAware(boolean unicodeAware) {
        this.unicodeAware = unicodeAware;
        return this;
    }

    @Override
    protected XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("fuzzy");
        if (this.fuzzyEditDistance != 1) {
            builder.field("edit_distance", this.fuzzyEditDistance);
        }
        if (!this.fuzzyTranspositions) {
            builder.field("transpositions", this.fuzzyTranspositions);
        }
        if (this.fuzzyMinLength != 3) {
            builder.field("min_length", this.fuzzyMinLength);
        }
        if (this.fuzzyPrefixLength != 1) {
            builder.field("prefix_length", this.fuzzyPrefixLength);
        }
        if (this.unicodeAware) {
            builder.field("unicode_aware", this.unicodeAware);
        }
        builder.endObject();
        return builder;
    }
}

