/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.completion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.text.StringText;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.index.mapper.core.CompletionFieldMapper;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.SuggestContextParser;
import org.elasticsearch.search.suggest.Suggester;
import org.elasticsearch.search.suggest.completion.Completion090PostingsFormat;
import org.elasticsearch.search.suggest.completion.CompletionSuggestParser;
import org.elasticsearch.search.suggest.completion.CompletionSuggestion;
import org.elasticsearch.search.suggest.completion.CompletionSuggestionContext;

public class CompletionSuggester
extends Suggester<CompletionSuggestionContext> {
    private static final ScoreComparator scoreComparator = new ScoreComparator();

    @Override
    protected Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>> innerExecute(String name, CompletionSuggestionContext suggestionContext, IndexReader indexReader, CharsRef spare) throws IOException {
        if (suggestionContext.mapper() == null || !(suggestionContext.mapper() instanceof CompletionFieldMapper)) {
            throw new ElasticSearchException("Field [" + suggestionContext.getField() + "] is not a completion suggest field");
        }
        CompletionSuggestion completionSuggestion = new CompletionSuggestion(name, suggestionContext.getSize());
        UnicodeUtil.UTF8toUTF16(suggestionContext.getText(), spare);
        CompletionSuggestion.Entry completionSuggestEntry = new CompletionSuggestion.Entry(new StringText(spare.toString()), 0, spare.length());
        completionSuggestion.addTerm(completionSuggestEntry);
        String fieldName = suggestionContext.getField();
        HashMap<String, CompletionSuggestion.Entry.Option> results = Maps.newHashMapWithExpectedSize(indexReader.leaves().size() * suggestionContext.getSize());
        for (AtomicReaderContext atomicReaderContext : indexReader.leaves()) {
            Completion090PostingsFormat.CompletionTerms lookupTerms;
            Lookup lookup2;
            AtomicReader atomicReader = atomicReaderContext.reader();
            Terms terms = atomicReader.fields().terms(fieldName);
            if (!(terms instanceof Completion090PostingsFormat.CompletionTerms) || (lookup2 = (lookupTerms = (Completion090PostingsFormat.CompletionTerms)terms).getLookup(suggestionContext.mapper(), suggestionContext)) == null) continue;
            List<Lookup.LookupResult> lookupResults = lookup2.lookup(spare, false, suggestionContext.getSize());
            for (Lookup.LookupResult res : lookupResults) {
                String key = ((Object)res.key).toString();
                float score = res.value;
                CompletionSuggestion.Entry.Option value2 = (CompletionSuggestion.Entry.Option)results.get(key);
                if (value2 == null) {
                    CompletionSuggestion.Entry.Option option = new CompletionSuggestion.Entry.Option((Text)new StringText(key), score, res.payload == null ? null : new BytesArray(res.payload));
                    results.put(key, option);
                    continue;
                }
                if (!(value2.getScore() < score)) continue;
                value2.setScore(score);
                value2.setPayload(res.payload == null ? null : new BytesArray(res.payload));
            }
        }
        ArrayList options = new ArrayList(results.values());
        CollectionUtil.introSort(options, scoreComparator);
        int optionCount = Math.min(suggestionContext.getSize(), options.size());
        for (int i = 0; i < optionCount; ++i) {
            completionSuggestEntry.addOption((Suggest.Suggestion.Entry.Option)options.get(i));
        }
        return completionSuggestion;
    }

    @Override
    public String[] names() {
        return new String[]{"completion"};
    }

    @Override
    public SuggestContextParser getContextParser() {
        return new CompletionSuggestParser(this);
    }

    public static class ScoreComparator
    implements Comparator<CompletionSuggestion.Entry.Option> {
        @Override
        public int compare(CompletionSuggestion.Entry.Option o1, CompletionSuggestion.Entry.Option o2) {
            return Float.compare(o2.getScore(), o1.getScore());
        }
    }
}

