/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.completion;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsConsumer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.TermStats;
import org.apache.lucene.codecs.TermsConsumer;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FilterAtomicReader;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.store.OutputStreamDataOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.search.suggest.completion.AnalyzingCompletionLookupProvider;
import org.elasticsearch.search.suggest.completion.CompletionStats;
import org.elasticsearch.search.suggest.completion.CompletionSuggestionContext;
import org.elasticsearch.search.suggest.completion.CompletionTokenStream;
import org.elasticsearch.search.suggest.completion.PayloadProcessor;

public class Completion090PostingsFormat
extends PostingsFormat {
    public static final String CODEC_NAME = "completion090";
    public static final int SUGGEST_CODEC_VERSION = 1;
    public static final String EXTENSION = "cmp";
    private static final ESLogger logger = Loggers.getLogger(Completion090PostingsFormat.class);
    private PostingsFormat delegatePostingsFormat;
    private static final Map<String, CompletionLookupProvider> providers;
    private CompletionLookupProvider writeProvider;

    public Completion090PostingsFormat(PostingsFormat delegatePostingsFormat, CompletionLookupProvider provider) {
        super(CODEC_NAME);
        this.delegatePostingsFormat = delegatePostingsFormat;
        this.writeProvider = provider;
        assert (delegatePostingsFormat != null && this.writeProvider != null);
    }

    public Completion090PostingsFormat() {
        super(CODEC_NAME);
    }

    @Override
    public CompletionFieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        if (this.delegatePostingsFormat == null) {
            throw new UnsupportedOperationException("Error - " + this.getClass().getName() + " has been constructed without a choice of PostingsFormat");
        }
        assert (this.writeProvider != null);
        return new CompletionFieldsConsumer(state);
    }

    @Override
    public CompletionFieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new CompletionFieldsProducer(state);
    }

    public CompletionStats completionStats(IndexReader indexReader, String ... fields) {
        CompletionStats completionStats = new CompletionStats();
        for (AtomicReaderContext atomicReaderContext : indexReader.leaves()) {
            AtomicReader atomicReader = atomicReaderContext.reader();
            try {
                for (String fieldName : atomicReader.fields()) {
                    Terms terms = atomicReader.fields().terms(fieldName);
                    if (!(terms instanceof CompletionTerms)) continue;
                    CompletionTerms completionTerms = (CompletionTerms)terms;
                    completionStats.add(completionTerms.stats(fields));
                }
            }
            catch (IOException e) {
                logger.error("Could not get completion stats: {}", e, e.getMessage());
            }
        }
        return completionStats;
    }

    static {
        AnalyzingCompletionLookupProvider provider = new AnalyzingCompletionLookupProvider(true, false, true, false);
        ImmutableMap.Builder<String, AnalyzingCompletionLookupProvider> builder = ImmutableMap.builder();
        providers = builder.put(((CompletionLookupProvider)provider).getName(), provider).build();
    }

    public static abstract class LookupFactory {
        public abstract Lookup getLookup(FieldMapper<?> var1, CompletionSuggestionContext var2);

        public abstract CompletionStats stats(String ... var1);

        abstract AnalyzingCompletionLookupProvider.AnalyzingSuggestHolder getAnalyzingSuggestHolder(FieldMapper<?> var1);
    }

    public static abstract class CompletionLookupProvider
    implements PayloadProcessor,
    CompletionTokenStream.ToFiniteStrings {
        public static final char UNIT_SEPARATOR = '\u001f';

        public abstract FieldsConsumer consumer(IndexOutput var1) throws IOException;

        public abstract String getName();

        public abstract LookupFactory load(IndexInput var1) throws IOException;

        @Override
        public BytesRef buildPayload(BytesRef surfaceForm, long weight, BytesRef payload) throws IOException {
            if (weight < -1L || weight > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("weight must be >= -1 && <= Integer.MAX_VALUE");
            }
            for (int i = 0; i < surfaceForm.length; ++i) {
                if (surfaceForm.bytes[i] != 31) continue;
                throw new IllegalArgumentException("surface form cannot contain unit separator character U+001F; this character is reserved");
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamDataOutput output2 = new OutputStreamDataOutput(byteArrayOutputStream);
            output2.writeVLong(weight + 1L);
            output2.writeVInt(surfaceForm.length);
            output2.writeBytes(surfaceForm.bytes, surfaceForm.offset, surfaceForm.length);
            output2.writeVInt(payload.length);
            output2.writeBytes(payload.bytes, 0, payload.length);
            output2.close();
            return new BytesRef(byteArrayOutputStream.toByteArray());
        }

        @Override
        public void parsePayload(BytesRef payload, PayloadProcessor.SuggestPayload ref) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(payload.bytes, payload.offset, payload.length);
            InputStreamDataInput input2 = new InputStreamDataInput(byteArrayInputStream);
            ref.weight = input2.readVLong() - 1L;
            int len = input2.readVInt();
            ref.surfaceForm.grow(len);
            ref.surfaceForm.length = len;
            input2.readBytes(ref.surfaceForm.bytes, ref.surfaceForm.offset, ref.surfaceForm.length);
            len = input2.readVInt();
            ref.payload.grow(len);
            ref.payload.length = len;
            input2.readBytes(ref.payload.bytes, ref.payload.offset, ref.payload.length);
            input2.close();
        }
    }

    public static final class CompletionTerms
    extends FilterAtomicReader.FilterTerms {
        private final LookupFactory lookup;

        public CompletionTerms(Terms delegate, LookupFactory lookup2) {
            super(delegate);
            this.lookup = lookup2;
        }

        public Lookup getLookup(FieldMapper<?> mapper, CompletionSuggestionContext suggestionContext) {
            return this.lookup.getLookup(mapper, suggestionContext);
        }

        public CompletionStats stats(String ... fields) {
            return this.lookup.stats(fields);
        }
    }

    private static class CompletionFieldsProducer
    extends FieldsProducer {
        private FieldsProducer delegateProducer;
        private LookupFactory lookupFactory;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompletionFieldsProducer(SegmentReadState state) throws IOException {
            block7: {
                IndexInput input2;
                block6: {
                    String suggestFSTFile = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, Completion090PostingsFormat.EXTENSION);
                    input2 = state.directory.openInput(suggestFSTFile, state.context);
                    CodecUtil.checkHeader(input2, Completion090PostingsFormat.CODEC_NAME, 1, 1);
                    boolean success2 = false;
                    try {
                        PostingsFormat delegatePostingsFormat = PostingsFormat.forName(input2.readString());
                        String providerName = input2.readString();
                        CompletionLookupProvider completionLookupProvider = (CompletionLookupProvider)providers.get(providerName);
                        if (completionLookupProvider == null) {
                            throw new ElasticSearchIllegalStateException("no provider with name [" + providerName + "] registered");
                        }
                        this.delegateProducer = delegatePostingsFormat.fieldsProducer(state);
                        if (state.context.context != IOContext.Context.MERGE) {
                            this.lookupFactory = completionLookupProvider.load(input2);
                        }
                        if (success2 = true) break block6;
                    }
                    catch (Throwable throwable) {
                        if (!success2) {
                            IOUtils.closeWhileHandlingException(this.delegateProducer, input2);
                        } else {
                            IOUtils.close(input2);
                        }
                        throw throwable;
                    }
                    IOUtils.closeWhileHandlingException(this.delegateProducer, input2);
                    break block7;
                }
                IOUtils.close(input2);
            }
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(new Closeable[]{this.delegateProducer});
        }

        @Override
        public Iterator<String> iterator() {
            return this.delegateProducer.iterator();
        }

        @Override
        public Terms terms(String field2) throws IOException {
            Terms terms = this.delegateProducer.terms(field2);
            if (terms == null) {
                return terms;
            }
            return new CompletionTerms(terms, this.lookupFactory);
        }

        @Override
        public int size() {
            return this.delegateProducer.size();
        }

        @Override
        public long ramBytesUsed() {
            return RamUsageEstimator.sizeOf(this.lookupFactory) + this.delegateProducer.ramBytesUsed();
        }
    }

    private class GroupedPostingsConsumer
    extends PostingsConsumer {
        private TermsConsumer[] termsConsumers;
        private PostingsConsumer[] postingsConsumers;

        public GroupedPostingsConsumer(TermsConsumer ... termsConsumersArgs) {
            this.termsConsumers = termsConsumersArgs;
            this.postingsConsumers = new PostingsConsumer[termsConsumersArgs.length];
        }

        @Override
        public void startDoc(int docID, int freq) throws IOException {
            for (PostingsConsumer postingsConsumer : this.postingsConsumers) {
                postingsConsumer.startDoc(docID, freq);
            }
        }

        @Override
        public void addPosition(int position, BytesRef payload, int startOffset, int endOffset) throws IOException {
            for (PostingsConsumer postingsConsumer : this.postingsConsumers) {
                postingsConsumer.addPosition(position, payload, startOffset, endOffset);
            }
        }

        @Override
        public void finishDoc() throws IOException {
            for (PostingsConsumer postingsConsumer : this.postingsConsumers) {
                postingsConsumer.finishDoc();
            }
        }

        public void startTerm(BytesRef text2) throws IOException {
            for (int i = 0; i < this.termsConsumers.length; ++i) {
                this.postingsConsumers[i] = this.termsConsumers[i].startTerm(text2);
            }
        }
    }

    private class CompletionFieldsConsumer
    extends FieldsConsumer {
        private FieldsConsumer delegatesFieldsConsumer;
        private FieldsConsumer suggestFieldsConsumer;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public CompletionFieldsConsumer(SegmentWriteState state) throws IOException {
            this.delegatesFieldsConsumer = Completion090PostingsFormat.this.delegatePostingsFormat.fieldsConsumer(state);
            String suggestFSTFile = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, Completion090PostingsFormat.EXTENSION);
            IndexOutput output2 = null;
            boolean success2 = false;
            try {
                output2 = state.directory.createOutput(suggestFSTFile, state.context);
                CodecUtil.writeHeader(output2, Completion090PostingsFormat.CODEC_NAME, 1);
                output2.writeString(Completion090PostingsFormat.this.delegatePostingsFormat.getName());
                output2.writeString(Completion090PostingsFormat.this.writeProvider.getName());
                this.suggestFieldsConsumer = Completion090PostingsFormat.this.writeProvider.consumer(output2);
                return;
            }
            catch (Throwable throwable) {
                if (success2) throw throwable;
                IOUtils.closeWhileHandlingException(output2);
                throw throwable;
            }
        }

        @Override
        public TermsConsumer addField(FieldInfo field2) throws IOException {
            final TermsConsumer delegateConsumer = this.delegatesFieldsConsumer.addField(field2);
            final TermsConsumer suggestTermConsumer = this.suggestFieldsConsumer.addField(field2);
            final GroupedPostingsConsumer groupedPostingsConsumer = new GroupedPostingsConsumer(delegateConsumer, suggestTermConsumer);
            return new TermsConsumer(){

                @Override
                public PostingsConsumer startTerm(BytesRef text2) throws IOException {
                    groupedPostingsConsumer.startTerm(text2);
                    return groupedPostingsConsumer;
                }

                @Override
                public Comparator<BytesRef> getComparator() throws IOException {
                    return delegateConsumer.getComparator();
                }

                @Override
                public void finishTerm(BytesRef text2, TermStats stats) throws IOException {
                    suggestTermConsumer.finishTerm(text2, stats);
                    delegateConsumer.finishTerm(text2, stats);
                }

                @Override
                public void finish(long sumTotalTermFreq, long sumDocFreq, int docCount) throws IOException {
                    suggestTermConsumer.finish(sumTotalTermFreq, sumDocFreq, docCount);
                    delegateConsumer.finish(sumTotalTermFreq, sumDocFreq, docCount);
                }
            };
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.delegatesFieldsConsumer, this.suggestFieldsConsumer);
        }
    }
}

