/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.completion;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.PostingsConsumer;
import org.apache.lucene.codecs.TermStats;
import org.apache.lucene.codecs.TermsConsumer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.analyzing.XAnalyzingSuggester;
import org.apache.lucene.search.suggest.analyzing.XFuzzySuggester;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.fst.ByteSequenceOutputs;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.PairOutputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.elasticsearch.common.hppc.ObjectLongOpenHashMap;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.search.suggest.completion.Completion090PostingsFormat;
import org.elasticsearch.search.suggest.completion.CompletionStats;
import org.elasticsearch.search.suggest.completion.CompletionSuggestionContext;
import org.elasticsearch.search.suggest.completion.PayloadProcessor;

public class AnalyzingCompletionLookupProvider
extends Completion090PostingsFormat.CompletionLookupProvider {
    public static final int SERIALIZE_PRESERVE_SEPERATORS = 1;
    public static final int SERIALIZE_HAS_PAYLOADS = 2;
    public static final int SERIALIZE_PRESERVE_POSITION_INCREMENTS = 4;
    private static final int MAX_SURFACE_FORMS_PER_ANALYZED_FORM = 256;
    private static final int MAX_GRAPH_EXPANSIONS = -1;
    public static final String CODEC_NAME = "analyzing";
    public static final int CODEC_VERSION_START = 1;
    public static final int CODEC_VERSION_LATEST = 2;
    private boolean preserveSep;
    private boolean preservePositionIncrements;
    private int maxSurfaceFormsPerAnalyzedForm;
    private int maxGraphExpansions;
    private boolean hasPayloads;
    private final XAnalyzingSuggester prototype;

    public AnalyzingCompletionLookupProvider(boolean preserveSep, boolean exactFirst, boolean preservePositionIncrements, boolean hasPayloads) {
        this.preserveSep = preserveSep;
        this.preservePositionIncrements = preservePositionIncrements;
        this.hasPayloads = hasPayloads;
        this.maxSurfaceFormsPerAnalyzedForm = 256;
        this.maxGraphExpansions = -1;
        int options = preserveSep ? 2 : 0;
        this.prototype = new XAnalyzingSuggester(null, null, options, this.maxSurfaceFormsPerAnalyzedForm, this.maxGraphExpansions, preservePositionIncrements, null, false, 1, 31, 31, 0, 30);
    }

    @Override
    public String getName() {
        return CODEC_NAME;
    }

    @Override
    public FieldsConsumer consumer(final IndexOutput output2) throws IOException {
        CodecUtil.writeHeader(output2, CODEC_NAME, 2);
        return new FieldsConsumer(){
            private Map<FieldInfo, Long> fieldOffsets = new HashMap<FieldInfo, Long>();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                try {
                    long pointer = output2.getFilePointer();
                    output2.writeVInt(this.fieldOffsets.size());
                    for (Map.Entry<FieldInfo, Long> entry2 : this.fieldOffsets.entrySet()) {
                        output2.writeString(entry2.getKey().name);
                        output2.writeVLong(entry2.getValue());
                    }
                    output2.writeLong(pointer);
                    output2.flush();
                }
                catch (Throwable throwable) {
                    IOUtils.close(output2);
                    throw throwable;
                }
                IOUtils.close(output2);
            }

            @Override
            public TermsConsumer addField(final FieldInfo field2) throws IOException {
                return new TermsConsumer(){
                    final XAnalyzingSuggester.XBuilder builder;
                    final CompletionPostingsConsumer postingsConsumer;
                    {
                        this.builder = new XAnalyzingSuggester.XBuilder(AnalyzingCompletionLookupProvider.this.maxSurfaceFormsPerAnalyzedForm, AnalyzingCompletionLookupProvider.this.hasPayloads, 31);
                        this.postingsConsumer = new CompletionPostingsConsumer(AnalyzingCompletionLookupProvider.this, this.builder);
                    }

                    @Override
                    public PostingsConsumer startTerm(BytesRef text2) throws IOException {
                        this.builder.startTerm(text2);
                        return this.postingsConsumer;
                    }

                    @Override
                    public Comparator<BytesRef> getComparator() throws IOException {
                        return BytesRef.getUTF8SortedAsUnicodeComparator();
                    }

                    @Override
                    public void finishTerm(BytesRef text2, TermStats stats) throws IOException {
                        this.builder.finishTerm(stats.docFreq);
                    }

                    @Override
                    public void finish(long sumTotalTermFreq, long sumDocFreq, int docCount) throws IOException {
                        FST<PairOutputs.Pair<Long, BytesRef>> build = this.builder.build();
                        assert (build != null || docCount == 0) : "the FST is null but docCount is != 0 actual value: [" + docCount + "]";
                        if (build != null) {
                            fieldOffsets.put(field2, output2.getFilePointer());
                            build.save(output2);
                            output2.writeVInt(this.postingsConsumer.getMaxAnalyzedPathsForOneInput());
                            output2.writeVInt(AnalyzingCompletionLookupProvider.this.maxSurfaceFormsPerAnalyzedForm);
                            output2.writeInt(AnalyzingCompletionLookupProvider.this.maxGraphExpansions);
                            int options = 0;
                            options |= AnalyzingCompletionLookupProvider.this.preserveSep ? 1 : 0;
                            options |= AnalyzingCompletionLookupProvider.this.hasPayloads ? 2 : 0;
                            output2.writeVInt(options |= AnalyzingCompletionLookupProvider.this.preservePositionIncrements ? 4 : 0);
                            output2.writeVInt(31);
                            output2.writeVInt(0);
                            output2.writeVInt(31);
                            output2.writeVInt(30);
                        }
                    }
                };
            }
        };
    }

    @Override
    public Completion090PostingsFormat.LookupFactory load(IndexInput input2) throws IOException {
        int version = CodecUtil.checkHeader(input2, CODEC_NAME, 1, 2);
        final HashMap lookupMap = new HashMap();
        input2.seek(input2.length() - 8L);
        long metaPointer = input2.readLong();
        input2.seek(metaPointer);
        int numFields = input2.readVInt();
        TreeMap<Long, String> meta = new TreeMap<Long, String>();
        for (int i = 0; i < numFields; ++i) {
            String name = input2.readString();
            long offset = input2.readVLong();
            meta.put(offset, name);
        }
        for (Map.Entry entry2 : meta.entrySet()) {
            int holeCharacter;
            int endByte;
            int payloadSep;
            int sepLabel;
            input2.seek((Long)entry2.getKey());
            FST<PairOutputs.Pair<Long, BytesRef>> fst = new FST<PairOutputs.Pair<Long, BytesRef>>(input2, new PairOutputs<Long, BytesRef>(PositiveIntOutputs.getSingleton(), ByteSequenceOutputs.getSingleton()));
            int maxAnalyzedPathsForOneInput = input2.readVInt();
            int maxSurfaceFormsPerAnalyzedForm = input2.readVInt();
            int maxGraphExpansions = input2.readInt();
            int options = input2.readVInt();
            boolean preserveSep = (options & 1) != 0;
            boolean hasPayloads = (options & 2) != 0;
            boolean preservePositionIncrements = (options & 4) != 0;
            switch (version) {
                case 1: {
                    sepLabel = 255;
                    payloadSep = 31;
                    endByte = 0;
                    holeCharacter = 30;
                    break;
                }
                default: {
                    sepLabel = input2.readVInt();
                    endByte = input2.readVInt();
                    payloadSep = input2.readVInt();
                    holeCharacter = input2.readVInt();
                }
            }
            AnalyzingSuggestHolder holder = new AnalyzingSuggestHolder(preserveSep, preservePositionIncrements, maxSurfaceFormsPerAnalyzedForm, maxGraphExpansions, hasPayloads, maxAnalyzedPathsForOneInput, fst, sepLabel, payloadSep, endByte, holeCharacter);
            lookupMap.put(entry2.getValue(), holder);
        }
        return new Completion090PostingsFormat.LookupFactory(){

            @Override
            public Lookup getLookup(FieldMapper<?> mapper, CompletionSuggestionContext suggestionContext) {
                AnalyzingSuggestHolder analyzingSuggestHolder = (AnalyzingSuggestHolder)lookupMap.get(mapper.names().indexName());
                if (analyzingSuggestHolder == null) {
                    return null;
                }
                int flags = analyzingSuggestHolder.preserveSep ? 2 : 0;
                XAnalyzingSuggester suggester = suggestionContext.isFuzzy() ? new XFuzzySuggester(mapper.indexAnalyzer(), mapper.searchAnalyzer(), flags, analyzingSuggestHolder.maxSurfaceFormsPerAnalyzedForm, analyzingSuggestHolder.maxGraphExpansions, suggestionContext.getFuzzyEditDistance(), suggestionContext.isFuzzyTranspositions(), suggestionContext.getFuzzyPrefixLength(), suggestionContext.getFuzzyMinLength(), suggestionContext.isFuzzyUnicodeAware(), analyzingSuggestHolder.fst, analyzingSuggestHolder.hasPayloads, analyzingSuggestHolder.maxAnalyzedPathsForOneInput, analyzingSuggestHolder.sepLabel, analyzingSuggestHolder.payloadSep, analyzingSuggestHolder.endByte, analyzingSuggestHolder.holeCharacter) : new XAnalyzingSuggester(mapper.indexAnalyzer(), mapper.searchAnalyzer(), flags, analyzingSuggestHolder.maxSurfaceFormsPerAnalyzedForm, analyzingSuggestHolder.maxGraphExpansions, analyzingSuggestHolder.preservePositionIncrements, analyzingSuggestHolder.fst, analyzingSuggestHolder.hasPayloads, analyzingSuggestHolder.maxAnalyzedPathsForOneInput, analyzingSuggestHolder.sepLabel, analyzingSuggestHolder.payloadSep, analyzingSuggestHolder.endByte, analyzingSuggestHolder.holeCharacter);
                return suggester;
            }

            @Override
            public CompletionStats stats(String ... fields) {
                long sizeInBytes2 = 0L;
                ObjectLongOpenHashMap<String> completionFields = null;
                if (fields != null && fields.length > 0) {
                    completionFields = new ObjectLongOpenHashMap<String>(fields.length);
                }
                for (Map.Entry entry2 : lookupMap.entrySet()) {
                    sizeInBytes2 += ((AnalyzingSuggestHolder)entry2.getValue()).fst.sizeInBytes();
                    if (fields == null || fields.length == 0) continue;
                    for (String field2 : fields) {
                        if (!Regex.simpleMatch(field2, (String)entry2.getKey())) continue;
                        long fstSize = ((AnalyzingSuggestHolder)entry2.getValue()).fst.sizeInBytes();
                        completionFields.addTo(field2, fstSize);
                    }
                }
                return new CompletionStats(sizeInBytes2, completionFields);
            }

            @Override
            AnalyzingSuggestHolder getAnalyzingSuggestHolder(FieldMapper<?> mapper) {
                return (AnalyzingSuggestHolder)lookupMap.get(mapper.names().indexName());
            }
        };
    }

    @Override
    public Set<IntsRef> toFiniteStrings(TokenStream stream) throws IOException {
        return this.prototype.toFiniteStrings(this.prototype.getTokenStreamToAutomaton(), stream);
    }

    static class AnalyzingSuggestHolder {
        final boolean preserveSep;
        final boolean preservePositionIncrements;
        final int maxSurfaceFormsPerAnalyzedForm;
        final int maxGraphExpansions;
        final boolean hasPayloads;
        final int maxAnalyzedPathsForOneInput;
        final FST<PairOutputs.Pair<Long, BytesRef>> fst;
        final int sepLabel;
        final int payloadSep;
        final int endByte;
        final int holeCharacter;

        public AnalyzingSuggestHolder(boolean preserveSep, boolean preservePositionIncrements, int maxSurfaceFormsPerAnalyzedForm, int maxGraphExpansions, boolean hasPayloads, int maxAnalyzedPathsForOneInput, FST<PairOutputs.Pair<Long, BytesRef>> fst) {
            this(preserveSep, preservePositionIncrements, maxSurfaceFormsPerAnalyzedForm, maxGraphExpansions, hasPayloads, maxAnalyzedPathsForOneInput, fst, 31, 31, 0, 30);
        }

        public AnalyzingSuggestHolder(boolean preserveSep, boolean preservePositionIncrements, int maxSurfaceFormsPerAnalyzedForm, int maxGraphExpansions, boolean hasPayloads, int maxAnalyzedPathsForOneInput, FST<PairOutputs.Pair<Long, BytesRef>> fst, int sepLabel, int payloadSep, int endByte, int holeCharacter) {
            this.preserveSep = preserveSep;
            this.preservePositionIncrements = preservePositionIncrements;
            this.maxSurfaceFormsPerAnalyzedForm = maxSurfaceFormsPerAnalyzedForm;
            this.maxGraphExpansions = maxGraphExpansions;
            this.hasPayloads = hasPayloads;
            this.maxAnalyzedPathsForOneInput = maxAnalyzedPathsForOneInput;
            this.fst = fst;
            this.sepLabel = sepLabel;
            this.payloadSep = payloadSep;
            this.endByte = endByte;
            this.holeCharacter = holeCharacter;
        }
    }

    private static final class CompletionPostingsConsumer
    extends PostingsConsumer {
        private final PayloadProcessor.SuggestPayload spare = new PayloadProcessor.SuggestPayload();
        private AnalyzingCompletionLookupProvider analyzingSuggestLookupProvider;
        private XAnalyzingSuggester.XBuilder builder;
        private int maxAnalyzedPathsForOneInput = 0;

        public CompletionPostingsConsumer(AnalyzingCompletionLookupProvider analyzingSuggestLookupProvider, XAnalyzingSuggester.XBuilder builder) {
            this.analyzingSuggestLookupProvider = analyzingSuggestLookupProvider;
            this.builder = builder;
        }

        @Override
        public void startDoc(int docID, int freq) throws IOException {
        }

        @Override
        public void addPosition(int position, BytesRef payload, int startOffset, int endOffset) throws IOException {
            this.analyzingSuggestLookupProvider.parsePayload(payload, this.spare);
            this.builder.addSurface(this.spare.surfaceForm, this.spare.payload, this.spare.weight);
            this.maxAnalyzedPathsForOneInput = Math.max(this.maxAnalyzedPathsForOneInput, position + 1);
        }

        @Override
        public void finishDoc() throws IOException {
        }

        public int getMaxAnalyzedPathsForOneInput() {
            return this.maxAnalyzedPathsForOneInput;
        }
    }
}

