/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest;

import java.io.IOException;
import java.util.Comparator;
import java.util.Locale;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.search.spell.DirectSpellChecker;
import org.apache.lucene.search.spell.JaroWinklerDistance;
import org.apache.lucene.search.spell.LevensteinDistance;
import org.apache.lucene.search.spell.LuceneLevenshteinDistance;
import org.apache.lucene.search.spell.NGramDistance;
import org.apache.lucene.search.spell.StringDistance;
import org.apache.lucene.search.spell.SuggestMode;
import org.apache.lucene.search.spell.SuggestWord;
import org.apache.lucene.search.spell.SuggestWordFrequencyComparator;
import org.apache.lucene.search.spell.SuggestWordQueue;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.io.FastCharArrayReader;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.CustomAnalyzer;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.ShingleTokenFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.search.suggest.DirectSpellcheckerSettings;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.SuggestionSearchContext;

public final class SuggestUtils {
    public static Comparator<SuggestWord> LUCENE_FREQUENCY = new SuggestWordFrequencyComparator();
    public static Comparator<SuggestWord> SCORE_COMPARATOR = SuggestWordQueue.DEFAULT_COMPARATOR;

    private SuggestUtils() {
    }

    public static DirectSpellChecker getDirectSpellChecker(DirectSpellcheckerSettings suggestion) {
        Comparator<SuggestWord> comparator;
        DirectSpellChecker directSpellChecker = new DirectSpellChecker();
        directSpellChecker.setAccuracy(suggestion.accuracy());
        switch (suggestion.sort()) {
            case SCORE: {
                comparator = SCORE_COMPARATOR;
                break;
            }
            case FREQUENCY: {
                comparator = LUCENE_FREQUENCY;
                break;
            }
            default: {
                throw new ElasticSearchIllegalArgumentException("Illegal suggest sort: " + (Object)((Object)suggestion.sort()));
            }
        }
        directSpellChecker.setComparator(comparator);
        directSpellChecker.setDistance(suggestion.stringDistance());
        directSpellChecker.setMaxEdits(suggestion.maxEdits());
        directSpellChecker.setMaxInspections(suggestion.maxInspections());
        directSpellChecker.setMaxQueryFrequency(suggestion.maxTermFreq());
        directSpellChecker.setMinPrefix(suggestion.prefixLength());
        directSpellChecker.setMinQueryLength(suggestion.minWordLength());
        directSpellChecker.setThresholdFrequency(suggestion.minDocFreq());
        directSpellChecker.setLowerCaseTerms(false);
        return directSpellChecker;
    }

    public static BytesRef join(BytesRef separator, BytesRef result2, BytesRef ... toJoin) {
        int len = separator.length * toJoin.length - 1;
        for (BytesRef br : toJoin) {
            len += br.length;
        }
        result2.grow(len);
        return SuggestUtils.joinPreAllocated(separator, result2, toJoin);
    }

    public static BytesRef joinPreAllocated(BytesRef separator, BytesRef result2, BytesRef ... toJoin) {
        result2.length = 0;
        result2.offset = 0;
        for (int i = 0; i < toJoin.length - 1; ++i) {
            BytesRef br = toJoin[i];
            System.arraycopy(br.bytes, br.offset, result2.bytes, result2.offset, br.length);
            result2.offset += br.length;
            System.arraycopy(separator.bytes, separator.offset, result2.bytes, result2.offset, separator.length);
            result2.offset += separator.length;
        }
        BytesRef br = toJoin[toJoin.length - 1];
        System.arraycopy(br.bytes, br.offset, result2.bytes, result2.offset, br.length);
        result2.length = result2.offset + br.length;
        result2.offset = 0;
        return result2;
    }

    public static int analyze(Analyzer analyzer, BytesRef toAnalyze, String field2, TokenConsumer consumer, CharsRef spare) throws IOException {
        UnicodeUtil.UTF8toUTF16(toAnalyze, spare);
        return SuggestUtils.analyze(analyzer, spare, field2, consumer);
    }

    public static int analyze(Analyzer analyzer, CharsRef toAnalyze, String field2, TokenConsumer consumer) throws IOException {
        TokenStream ts = analyzer.tokenStream(field2, new FastCharArrayReader(toAnalyze.chars, toAnalyze.offset, toAnalyze.length));
        return SuggestUtils.analyze(ts, consumer);
    }

    public static int analyze(TokenStream stream, TokenConsumer consumer) throws IOException {
        stream.reset();
        consumer.reset(stream);
        int numTokens = 0;
        while (stream.incrementToken()) {
            consumer.nextToken();
            ++numTokens;
        }
        consumer.end();
        stream.close();
        return numTokens;
    }

    public static SuggestMode resolveSuggestMode(String suggestMode) {
        if ("missing".equals(suggestMode = suggestMode.toLowerCase(Locale.US))) {
            return SuggestMode.SUGGEST_WHEN_NOT_IN_INDEX;
        }
        if ("popular".equals(suggestMode)) {
            return SuggestMode.SUGGEST_MORE_POPULAR;
        }
        if ("always".equals(suggestMode)) {
            return SuggestMode.SUGGEST_ALWAYS;
        }
        throw new ElasticSearchIllegalArgumentException("Illegal suggest mode " + suggestMode);
    }

    public static Suggest.Suggestion.Sort resolveSort(String sortVal) {
        if ("score".equals(sortVal)) {
            return Suggest.Suggestion.Sort.SCORE;
        }
        if ("frequency".equals(sortVal)) {
            return Suggest.Suggestion.Sort.FREQUENCY;
        }
        throw new ElasticSearchIllegalArgumentException("Illegal suggest sort " + sortVal);
    }

    public static StringDistance resolveDistance(String distanceVal) {
        if ("internal".equals(distanceVal)) {
            return DirectSpellChecker.INTERNAL_LEVENSHTEIN;
        }
        if ("damerau_levenshtein".equals(distanceVal) || "damerauLevenshtein".equals(distanceVal)) {
            return new LuceneLevenshteinDistance();
        }
        if ("levenstein".equals(distanceVal)) {
            return new LevensteinDistance();
        }
        if ("jarowinkler".equals(distanceVal)) {
            return new JaroWinklerDistance();
        }
        if ("ngram".equals(distanceVal)) {
            return new NGramDistance();
        }
        throw new ElasticSearchIllegalArgumentException("Illegal distance option " + distanceVal);
    }

    public static boolean parseDirectSpellcheckerSettings(XContentParser parser, String fieldName, DirectSpellcheckerSettings suggestion) throws IOException {
        if ("accuracy".equals(fieldName)) {
            suggestion.accuracy(parser.floatValue());
        } else if ("suggest_mode".equals(fieldName) || "suggestMode".equals(fieldName)) {
            suggestion.suggestMode(SuggestUtils.resolveSuggestMode(parser.text()));
        } else if ("sort".equals(fieldName)) {
            suggestion.sort(SuggestUtils.resolveSort(parser.text()));
        } else if ("string_distance".equals(fieldName) || "stringDistance".equals(fieldName)) {
            suggestion.stringDistance(SuggestUtils.resolveDistance(parser.text()));
        } else if ("max_edits".equals(fieldName) || "maxEdits".equals(fieldName)) {
            suggestion.maxEdits(parser.intValue());
            if (suggestion.maxEdits() < 1 || suggestion.maxEdits() > 2) {
                throw new ElasticSearchIllegalArgumentException("Illegal max_edits value " + suggestion.maxEdits());
            }
        } else if ("max_inspections".equals(fieldName) || "maxInspections".equals(fieldName)) {
            suggestion.maxInspections(parser.intValue());
        } else if ("max_term_freq".equals(fieldName) || "maxTermFreq".equals(fieldName)) {
            suggestion.maxTermFreq(parser.floatValue());
        } else if ("prefix_len".equals(fieldName) || "prefixLen".equals(fieldName)) {
            suggestion.prefixLength(parser.intValue());
        } else if ("min_word_len".equals(fieldName) || "minWordLen".equals(fieldName)) {
            suggestion.minQueryLength(parser.intValue());
        } else if ("min_doc_freq".equals(fieldName) || "minDocFreq".equals(fieldName)) {
            suggestion.minDocFreq(parser.floatValue());
        } else {
            return false;
        }
        return true;
    }

    public static boolean parseSuggestContext(XContentParser parser, MapperService mapperService, String fieldName, SuggestionSearchContext.SuggestionContext suggestion) throws IOException {
        if ("analyzer".equals(fieldName)) {
            String analyzerName = parser.text();
            NamedAnalyzer analyzer = mapperService.analysisService().analyzer(analyzerName);
            if (analyzer == null) {
                throw new ElasticSearchIllegalArgumentException("Analyzer [" + analyzerName + "] doesn't exists");
            }
            suggestion.setAnalyzer(analyzer);
        } else if ("field".equals(fieldName)) {
            suggestion.setField(parser.text());
        } else if ("size".equals(fieldName)) {
            suggestion.setSize(parser.intValue());
        } else if ("shard_size".equals(fieldName) || "shardSize".equals(fieldName)) {
            suggestion.setShardSize(parser.intValue());
        } else {
            return false;
        }
        return true;
    }

    public static void verifySuggestion(MapperService mapperService, BytesRef globalText, SuggestionSearchContext.SuggestionContext suggestion) {
        if (suggestion.getField() == null) {
            throw new ElasticSearchIllegalArgumentException("The required field option is missing");
        }
        if (suggestion.getText() == null) {
            if (globalText == null) {
                throw new ElasticSearchIllegalArgumentException("The required text option is missing");
            }
            suggestion.setText(globalText);
        }
        if (suggestion.getAnalyzer() == null) {
            suggestion.setAnalyzer(mapperService.searchAnalyzer());
        }
        if (suggestion.getShardSize() == -1) {
            suggestion.setShardSize(Math.max(suggestion.getSize(), 5));
        }
    }

    public static ShingleTokenFilterFactory.Factory getShingleFilterFactory(Analyzer analyzer) {
        if (analyzer instanceof NamedAnalyzer) {
            analyzer = ((NamedAnalyzer)analyzer).analyzer();
        }
        if (analyzer instanceof CustomAnalyzer) {
            TokenFilterFactory[] tokenFilters;
            CustomAnalyzer a = (CustomAnalyzer)analyzer;
            for (TokenFilterFactory tokenFilterFactory : tokenFilters = a.tokenFilters()) {
                if (tokenFilterFactory instanceof ShingleTokenFilterFactory) {
                    return ((ShingleTokenFilterFactory)tokenFilterFactory).getInnerFactory();
                }
                if (!(tokenFilterFactory instanceof ShingleTokenFilterFactory.Factory)) continue;
                return (ShingleTokenFilterFactory.Factory)tokenFilterFactory;
            }
        }
        return null;
    }

    public static abstract class TokenConsumer {
        protected CharTermAttribute charTermAttr;
        protected PositionIncrementAttribute posIncAttr;
        protected OffsetAttribute offsetAttr;

        public void reset(TokenStream stream) {
            this.charTermAttr = stream.addAttribute(CharTermAttribute.class);
            this.posIncAttr = stream.addAttribute(PositionIncrementAttribute.class);
            this.offsetAttr = stream.addAttribute(OffsetAttribute.class);
        }

        protected BytesRef fillBytesRef(BytesRef spare) {
            spare.offset = 0;
            spare.length = spare.bytes.length;
            char[] source = this.charTermAttr.buffer();
            UnicodeUtil.UTF16toUTF8(source, 0, this.charTermAttr.length(), spare);
            return spare;
        }

        public abstract void nextToken() throws IOException;

        public void end() {
        }
    }
}

