/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.sort;

import java.util.Map;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.SortField;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.DoubleScriptDataComparator;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;
import org.elasticsearch.index.fielddata.fieldcomparator.StringScriptDataComparator;
import org.elasticsearch.index.mapper.ObjectMappers;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.query.ParsedFilter;
import org.elasticsearch.index.search.nested.NestedFieldComparatorSource;
import org.elasticsearch.index.search.nested.NonNestedDocsFilter;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.sort.SortParser;

public class ScriptSortParser
implements SortParser {
    @Override
    public String[] names() {
        return new String[]{"_script"};
    }

    @Override
    public SortField parse(XContentParser parser, SearchContext context) throws Exception {
        IndexFieldData.XFieldComparatorSource fieldComparatorSource;
        XContentParser.Token token2;
        String script = null;
        String scriptLang = null;
        String type = null;
        Map<String, Object> params = null;
        boolean reverse2 = false;
        SortMode sortMode = null;
        String nestedPath = null;
        Filter nestedFilter = null;
        String currentName = parser.currentName();
        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token2 == XContentParser.Token.FIELD_NAME) {
                currentName = parser.currentName();
                continue;
            }
            if (token2 == XContentParser.Token.START_OBJECT) {
                if ("params".equals(currentName)) {
                    params = parser.map();
                    continue;
                }
                if (!"nested_filter".equals(currentName) && !"nestedFilter".equals(currentName)) continue;
                ParsedFilter parsedFilter = context.queryParserService().parseInnerFilter(parser);
                nestedFilter = parsedFilter == null ? null : parsedFilter.filter();
                continue;
            }
            if (!token2.isValue()) continue;
            if ("reverse".equals(currentName)) {
                reverse2 = parser.booleanValue();
                continue;
            }
            if ("order".equals(currentName)) {
                reverse2 = "desc".equals(parser.text());
                continue;
            }
            if ("script".equals(currentName)) {
                script = parser.text();
                continue;
            }
            if ("type".equals(currentName)) {
                type = parser.text();
                continue;
            }
            if ("lang".equals(currentName)) {
                scriptLang = parser.text();
                continue;
            }
            if ("mode".equals(currentName)) {
                sortMode = SortMode.fromString(parser.text());
                continue;
            }
            if (!"nested_path".equals(currentName) && !"nestedPath".equals(currentName)) continue;
            nestedPath = parser.text();
        }
        if (script == null) {
            throw new SearchParseException(context, "_script sorting requires setting the script to sort by");
        }
        if (type == null) {
            throw new SearchParseException(context, "_script sorting requires setting the type of the script");
        }
        SearchScript searchScript = context.scriptService().search(context.lookup(), scriptLang, script, params);
        if ("string".equals(type)) {
            fieldComparatorSource = StringScriptDataComparator.comparatorSource(searchScript);
        } else if ("number".equals(type)) {
            fieldComparatorSource = DoubleScriptDataComparator.comparatorSource(searchScript);
        } else {
            throw new SearchParseException(context, "custom script sort type [" + type + "] not supported");
        }
        if ("string".equals(type) && (sortMode == SortMode.SUM || sortMode == SortMode.AVG)) {
            throw new SearchParseException(context, "type [string] doesn't support mode [" + (Object)((Object)sortMode) + "]");
        }
        if (sortMode == null) {
            SortMode sortMode2 = sortMode = reverse2 ? SortMode.MAX : SortMode.MIN;
        }
        if (nestedPath != null) {
            ObjectMappers objectMappers = context.mapperService().objectMapper(nestedPath);
            if (objectMappers == null) {
                throw new ElasticSearchIllegalArgumentException("failed to find nested object mapping for explicit nested path [" + nestedPath + "]");
            }
            ObjectMapper objectMapper = objectMappers.mapper();
            if (!objectMapper.nested().isNested()) {
                throw new ElasticSearchIllegalArgumentException("mapping for explicit nested path is not mapped as nested: [" + nestedPath + "]");
            }
            Filter rootDocumentsFilter = context.filterCache().cache(NonNestedDocsFilter.INSTANCE);
            Filter innerDocumentsFilter = nestedFilter != null ? context.filterCache().cache(nestedFilter) : context.filterCache().cache(objectMapper.nestedTypeFilter());
            fieldComparatorSource = new NestedFieldComparatorSource(sortMode, fieldComparatorSource, rootDocumentsFilter, innerDocumentsFilter);
        }
        return new SortField("_script", fieldComparatorSource, reverse2);
    }
}

