/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.sort;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class ScriptSortBuilder
extends SortBuilder {
    private String lang;
    private final String script;
    private final String type;
    private SortOrder order;
    private Map<String, Object> params;
    private String sortMode;
    private FilterBuilder nestedFilter;
    private String nestedPath;

    public ScriptSortBuilder(String script, String type) {
        this.script = script;
        this.type = type;
    }

    public ScriptSortBuilder param(String name, Object value2) {
        if (this.params == null) {
            this.params = Maps.newHashMap();
        }
        this.params.put(name, value2);
        return this;
    }

    public ScriptSortBuilder setParams(Map<String, Object> params) {
        this.params = params;
        return this;
    }

    @Override
    public ScriptSortBuilder order(SortOrder order) {
        this.order = order;
        return this;
    }

    @Override
    public SortBuilder missing(Object missing) {
        return this;
    }

    public ScriptSortBuilder lang(String lang) {
        this.lang = lang;
        return this;
    }

    public ScriptSortBuilder sortMode(String sortMode) {
        this.sortMode = sortMode;
        return this;
    }

    public ScriptSortBuilder setNestedFilter(FilterBuilder nestedFilter) {
        this.nestedFilter = nestedFilter;
        return this;
    }

    public ScriptSortBuilder setNestedPath(String nestedPath) {
        this.nestedPath = nestedPath;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("_script");
        builder.field("script", this.script);
        builder.field("type", this.type);
        if (this.order == SortOrder.DESC) {
            builder.field("reverse", true);
        }
        if (this.lang != null) {
            builder.field("lang", this.lang);
        }
        if (this.params != null) {
            builder.field("params", this.params);
        }
        if (this.sortMode != null) {
            builder.field("mode", this.sortMode);
        }
        if (this.nestedPath != null) {
            builder.field("nested_path", this.nestedPath);
        }
        if (this.nestedFilter != null) {
            builder.field("nested_filter", this.nestedFilter, params);
        }
        builder.endObject();
        return builder;
    }
}

