/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;

public class DocLookup
implements Map {
    private final Map<String, ScriptDocValues> localCacheFieldData = Maps.newHashMapWithExpectedSize(4);
    private final MapperService mapperService;
    private final IndexFieldDataService fieldDataService;
    @Nullable
    private final String[] types;
    private AtomicReaderContext reader;
    private Scorer scorer;
    private int docId = -1;

    DocLookup(MapperService mapperService, IndexFieldDataService fieldDataService, @Nullable String[] types) {
        this.mapperService = mapperService;
        this.fieldDataService = fieldDataService;
        this.types = types;
    }

    public MapperService mapperService() {
        return this.mapperService;
    }

    public void setNextReader(AtomicReaderContext context) {
        if (this.reader == context) {
            return;
        }
        this.reader = context;
        this.docId = -1;
        this.localCacheFieldData.clear();
    }

    public void setScorer(Scorer scorer) {
        this.scorer = scorer;
    }

    public void setNextDocId(int docId) {
        this.docId = docId;
    }

    public float score() throws IOException {
        return this.scorer.score();
    }

    public float getScore() throws IOException {
        return this.scorer.score();
    }

    public Object get(Object key) {
        String fieldName = key.toString();
        ScriptDocValues scriptValues = this.localCacheFieldData.get(fieldName);
        if (scriptValues == null) {
            FieldMapper mapper = this.mapperService.smartNameFieldMapper(fieldName, this.types);
            if (mapper == null) {
                throw new ElasticSearchIllegalArgumentException("No field found for [" + fieldName + "] in mapping with types " + Arrays.toString(this.types) + "");
            }
            scriptValues = this.fieldDataService.getForField(mapper).load(this.reader).getScriptValues();
            this.localCacheFieldData.put(fieldName, scriptValues);
        }
        scriptValues.setNextDocId(this.docId);
        return scriptValues;
    }

    @Override
    public boolean containsKey(Object key) {
        FieldMapper mapper;
        String fieldName = key.toString();
        ScriptDocValues scriptValues = this.localCacheFieldData.get(fieldName);
        return scriptValues != null || (mapper = this.mapperService.smartNameFieldMapper(fieldName, this.types)) != null;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value2) {
        throw new UnsupportedOperationException();
    }

    public Object put(Object key, Object value2) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }
}

