/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.highlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.NullFragmenter;
import org.apache.lucene.search.highlight.SimpleFragmenter;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.SimpleSpanFragmenter;
import org.apache.lucene.search.highlight.TextFragment;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.text.StringText;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.search.fetch.FetchPhaseExecutionException;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.highlight.CustomQueryScorer;
import org.elasticsearch.search.highlight.HighlightField;
import org.elasticsearch.search.highlight.HighlightUtils;
import org.elasticsearch.search.highlight.Highlighter;
import org.elasticsearch.search.highlight.HighlighterContext;
import org.elasticsearch.search.highlight.SearchContextHighlight;
import org.elasticsearch.search.internal.SearchContext;

public class PlainHighlighter
implements Highlighter {
    private static final String CACHE_KEY = "highlight-plain";

    @Override
    public String[] names() {
        return new String[]{"plain", "highlighter"};
    }

    @Override
    public HighlightField highlight(HighlighterContext highlighterContext) {
        int i;
        String[] fragments;
        Analyzer analyzer;
        List<Object> textsToHighlight;
        Map cache;
        org.apache.lucene.search.highlight.Highlighter entry2;
        Encoder encoder2;
        SearchContextHighlight.Field field2 = highlighterContext.field;
        SearchContext context = highlighterContext.context;
        FetchSubPhase.HitContext hitContext = highlighterContext.hitContext;
        FieldMapper<?> mapper = highlighterContext.mapper;
        Encoder encoder3 = encoder2 = field2.encoder().equals("html") ? HighlightUtils.Encoders.HTML : HighlightUtils.Encoders.DEFAULT;
        if (!hitContext.cache().containsKey(CACHE_KEY)) {
            HashMap mappers = Maps.newHashMap();
            hitContext.cache().put(CACHE_KEY, mappers);
        }
        if ((entry2 = (org.apache.lucene.search.highlight.Highlighter)(cache = (Map)hitContext.cache().get(CACHE_KEY)).get(mapper)) == null) {
            Fragmenter fragmenter;
            Query query = highlighterContext.query.originalQuery();
            CustomQueryScorer queryScorer = new CustomQueryScorer(query, field2.requireFieldMatch() != false ? mapper.names().indexName() : null);
            queryScorer.setExpandMultiTermQuery(true);
            if (field2.numberOfFragments() == 0) {
                fragmenter = new NullFragmenter();
            } else if (field2.fragmenter() == null) {
                fragmenter = new SimpleSpanFragmenter(queryScorer, field2.fragmentCharSize());
            } else if ("simple".equals(field2.fragmenter())) {
                fragmenter = new SimpleFragmenter(field2.fragmentCharSize());
            } else if ("span".equals(field2.fragmenter())) {
                fragmenter = new SimpleSpanFragmenter(queryScorer, field2.fragmentCharSize());
            } else {
                throw new ElasticSearchIllegalArgumentException("unknown fragmenter option [" + field2.fragmenter() + "] for the field [" + highlighterContext.fieldName + "]");
            }
            SimpleHTMLFormatter formatter = new SimpleHTMLFormatter(field2.preTags()[0], field2.postTags()[0]);
            entry2 = new org.apache.lucene.search.highlight.Highlighter(formatter, encoder2, queryScorer);
            entry2.setTextFragmenter(fragmenter);
            entry2.setMaxDocCharsToAnalyze(Integer.MAX_VALUE);
            cache.put(mapper, entry2);
        }
        int numberOfFragments = field2.numberOfFragments() == 0 ? 1 : field2.numberOfFragments();
        ArrayList<TextFragment> fragsList = new ArrayList<TextFragment>();
        try {
            textsToHighlight = HighlightUtils.loadFieldValues(mapper, context, hitContext);
            for (Object textToHighlight : textsToHighlight) {
                TextFragment[] bestTextFragments;
                String text2 = textToHighlight.toString();
                analyzer = context.mapperService().documentMapper(hitContext.hit().type()).mappers().indexAnalyzer();
                TokenStream tokenStream = analyzer.tokenStream(mapper.names().indexName(), text2);
                if (!tokenStream.hasAttribute(CharTermAttribute.class) || !tokenStream.hasAttribute(OffsetAttribute.class)) continue;
                for (TextFragment bestTextFragment : bestTextFragments = entry2.getBestTextFragments(tokenStream, text2, false, numberOfFragments)) {
                    if (bestTextFragment == null || !(bestTextFragment.getScore() > 0.0f)) continue;
                    fragsList.add(bestTextFragment);
                }
            }
        }
        catch (Exception e) {
            throw new FetchPhaseExecutionException(context, "Failed to highlight field [" + highlighterContext.fieldName + "]", (Throwable)e);
        }
        if (field2.scoreOrdered().booleanValue()) {
            CollectionUtil.introSort(fragsList, new Comparator<TextFragment>(){

                @Override
                public int compare(TextFragment o1, TextFragment o2) {
                    return Math.round(o2.getScore() - o1.getScore());
                }
            });
        }
        if (field2.numberOfFragments() == 0 && textsToHighlight.size() > 1 && fragsList.size() > 0) {
            fragments = new String[fragsList.size()];
            for (i = 0; i < fragsList.size(); ++i) {
                fragments[i] = ((TextFragment)fragsList.get(i)).toString();
            }
        } else {
            numberOfFragments = fragsList.size() < numberOfFragments ? fragsList.size() : numberOfFragments;
            fragments = new String[numberOfFragments];
            for (i = 0; i < fragments.length; ++i) {
                fragments[i] = ((TextFragment)fragsList.get(i)).toString();
            }
        }
        if (fragments != null && fragments.length > 0) {
            return new HighlightField(highlighterContext.fieldName, StringText.convertFromStringArray(fragments));
        }
        int noMatchSize = highlighterContext.field.noMatchSize();
        if (noMatchSize > 0 && textsToHighlight.size() > 0) {
            int end;
            String fieldContents = textsToHighlight.get(0).toString();
            analyzer = context.mapperService().documentMapper(hitContext.hit().type()).mappers().indexAnalyzer();
            try {
                end = PlainHighlighter.findGoodEndForNoHighlightExcerpt(noMatchSize, analyzer.tokenStream(mapper.names().indexName(), fieldContents));
            }
            catch (Exception e) {
                throw new FetchPhaseExecutionException(context, "Failed to highlight field [" + highlighterContext.fieldName + "]", (Throwable)e);
            }
            if (end > 0) {
                return new HighlightField(highlighterContext.fieldName, new Text[]{new StringText(fieldContents.substring(0, end))});
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int findGoodEndForNoHighlightExcerpt(int noMatchSize, TokenStream tokenStream) throws IOException {
        try {
            if (!tokenStream.hasAttribute(OffsetAttribute.class)) {
                int n = -1;
                return n;
            }
            int end = -1;
            tokenStream.reset();
            while (tokenStream.incrementToken()) {
                OffsetAttribute attr = tokenStream.getAttribute(OffsetAttribute.class);
                if (attr.endOffset() >= noMatchSize) {
                    if (attr.endOffset() == noMatchSize) {
                        end = noMatchSize;
                    }
                    int n = end;
                    return n;
                }
                end = attr.endOffset();
            }
            int n = end;
            return n;
        }
        finally {
            tokenStream.end();
            tokenStream.close();
        }
    }
}

