/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.highlight;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.vectorhighlight.SimpleBoundaryScanner;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.highlight.SearchContextHighlight;
import org.elasticsearch.search.internal.SearchContext;

public class HighlighterParseElement
implements SearchParseElement {
    private static final String[] DEFAULT_PRE_TAGS = new String[]{"<em>"};
    private static final String[] DEFAULT_POST_TAGS = new String[]{"</em>"};
    private static final String[] STYLED_PRE_TAG = new String[]{"<em class=\"hlt1\">", "<em class=\"hlt2\">", "<em class=\"hlt3\">", "<em class=\"hlt4\">", "<em class=\"hlt5\">", "<em class=\"hlt6\">", "<em class=\"hlt7\">", "<em class=\"hlt8\">", "<em class=\"hlt9\">", "<em class=\"hlt10\">"};
    private static final String[] STYLED_POST_TAGS = new String[]{"</em>"};

    @Override
    public void parse(XContentParser parser, SearchContext context) throws Exception {
        XContentParser.Token token2;
        String topLevelFieldName = null;
        ArrayList<SearchContextHighlight.Field> fields = Lists.newArrayList();
        String[] globalPreTags = DEFAULT_PRE_TAGS;
        String[] globalPostTags = DEFAULT_POST_TAGS;
        boolean globalScoreOrdered = false;
        boolean globalHighlightFilter = false;
        boolean globalRequireFieldMatch = false;
        int globalFragmentSize = 100;
        int globalNumOfFragments = 5;
        String globalEncoder = "default";
        int globalBoundaryMaxScan = 20;
        Character[] globalBoundaryChars = SimpleBoundaryScanner.DEFAULT_BOUNDARY_CHARS;
        String globalHighlighterType = null;
        String globalFragmenter = null;
        Map<String, Object> globalOptions = null;
        Query globalHighlightQuery = null;
        int globalNoMatchSize = 0;
        int globalPhraseLimit = 256;
        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token2 == XContentParser.Token.FIELD_NAME) {
                topLevelFieldName = parser.currentName();
                continue;
            }
            if (token2 == XContentParser.Token.START_ARRAY) {
                if ("pre_tags".equals(topLevelFieldName) || "preTags".equals(topLevelFieldName)) {
                    ArrayList<String> preTagsList = Lists.newArrayList();
                    while ((token2 = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        preTagsList.add(parser.text());
                    }
                    globalPreTags = preTagsList.toArray(new String[preTagsList.size()]);
                    continue;
                }
                if (!"post_tags".equals(topLevelFieldName) && !"postTags".equals(topLevelFieldName)) continue;
                ArrayList<String> postTagsList = Lists.newArrayList();
                while ((token2 = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    postTagsList.add(parser.text());
                }
                globalPostTags = postTagsList.toArray(new String[postTagsList.size()]);
                continue;
            }
            if (token2.isValue()) {
                if ("order".equals(topLevelFieldName)) {
                    globalScoreOrdered = "score".equals(parser.text());
                    continue;
                }
                if ("tags_schema".equals(topLevelFieldName) || "tagsSchema".equals(topLevelFieldName)) {
                    String schema = parser.text();
                    if (!"styled".equals(schema)) continue;
                    globalPreTags = STYLED_PRE_TAG;
                    globalPostTags = STYLED_POST_TAGS;
                    continue;
                }
                if ("highlight_filter".equals(topLevelFieldName) || "highlightFilter".equals(topLevelFieldName)) {
                    globalHighlightFilter = parser.booleanValue();
                    continue;
                }
                if ("fragment_size".equals(topLevelFieldName) || "fragmentSize".equals(topLevelFieldName)) {
                    globalFragmentSize = parser.intValue();
                    continue;
                }
                if ("number_of_fragments".equals(topLevelFieldName) || "numberOfFragments".equals(topLevelFieldName)) {
                    globalNumOfFragments = parser.intValue();
                    continue;
                }
                if ("encoder".equals(topLevelFieldName)) {
                    globalEncoder = parser.text();
                    continue;
                }
                if ("require_field_match".equals(topLevelFieldName) || "requireFieldMatch".equals(topLevelFieldName)) {
                    globalRequireFieldMatch = parser.booleanValue();
                    continue;
                }
                if ("boundary_max_scan".equals(topLevelFieldName) || "boundaryMaxScan".equals(topLevelFieldName)) {
                    globalBoundaryMaxScan = parser.intValue();
                    continue;
                }
                if ("boundary_chars".equals(topLevelFieldName) || "boundaryChars".equals(topLevelFieldName)) {
                    char[] charsArr = parser.text().toCharArray();
                    globalBoundaryChars = new Character[charsArr.length];
                    for (int i = 0; i < charsArr.length; ++i) {
                        globalBoundaryChars[i] = Character.valueOf(charsArr[i]);
                    }
                    continue;
                }
                if ("type".equals(topLevelFieldName)) {
                    globalHighlighterType = parser.text();
                    continue;
                }
                if ("fragmenter".equals(topLevelFieldName)) {
                    globalFragmenter = parser.text();
                    continue;
                }
                if ("no_match_size".equals(topLevelFieldName) || "noMatchSize".equals(topLevelFieldName)) {
                    globalNoMatchSize = parser.intValue();
                    continue;
                }
                if (!"phrase_limit".equals(topLevelFieldName) && !"phraseLimit".equals(topLevelFieldName)) continue;
                globalPhraseLimit = parser.intValue();
                continue;
            }
            if (token2 == XContentParser.Token.START_OBJECT && "options".equals(topLevelFieldName)) {
                globalOptions = parser.map();
                continue;
            }
            if (token2 != XContentParser.Token.START_OBJECT) continue;
            if ("fields".equals(topLevelFieldName)) {
                String highlightFieldName = null;
                while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token2 == XContentParser.Token.FIELD_NAME) {
                        highlightFieldName = parser.currentName();
                        continue;
                    }
                    if (token2 != XContentParser.Token.START_OBJECT) continue;
                    SearchContextHighlight.Field field2 = new SearchContextHighlight.Field(highlightFieldName);
                    String fieldName = null;
                    while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token2 == XContentParser.Token.FIELD_NAME) {
                            fieldName = parser.currentName();
                            continue;
                        }
                        if (token2 == XContentParser.Token.START_ARRAY) {
                            if ("pre_tags".equals(fieldName) || "preTags".equals(fieldName)) {
                                ArrayList<String> preTagsList = Lists.newArrayList();
                                while ((token2 = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                    preTagsList.add(parser.text());
                                }
                                field2.preTags(preTagsList.toArray(new String[preTagsList.size()]));
                                continue;
                            }
                            if ("post_tags".equals(fieldName) || "postTags".equals(fieldName)) {
                                ArrayList<String> postTagsList = Lists.newArrayList();
                                while ((token2 = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                    postTagsList.add(parser.text());
                                }
                                field2.postTags(postTagsList.toArray(new String[postTagsList.size()]));
                                continue;
                            }
                            if (!"matched_fields".equals(fieldName) && !"matchedFields".equals(fieldName)) continue;
                            HashSet<String> matchedFields = Sets.newHashSet();
                            while ((token2 = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                matchedFields.add(parser.text());
                            }
                            field2.matchedFields(matchedFields);
                            continue;
                        }
                        if (token2.isValue()) {
                            if ("fragment_size".equals(fieldName) || "fragmentSize".equals(fieldName)) {
                                field2.fragmentCharSize(parser.intValue());
                                continue;
                            }
                            if ("number_of_fragments".equals(fieldName) || "numberOfFragments".equals(fieldName)) {
                                field2.numberOfFragments(parser.intValue());
                                continue;
                            }
                            if ("fragment_offset".equals(fieldName) || "fragmentOffset".equals(fieldName)) {
                                field2.fragmentOffset(parser.intValue());
                                continue;
                            }
                            if ("highlight_filter".equals(fieldName) || "highlightFilter".equals(fieldName)) {
                                field2.highlightFilter(parser.booleanValue());
                                continue;
                            }
                            if ("order".equals(fieldName)) {
                                field2.scoreOrdered("score".equals(parser.text()));
                                continue;
                            }
                            if ("require_field_match".equals(fieldName) || "requireFieldMatch".equals(fieldName)) {
                                field2.requireFieldMatch(parser.booleanValue());
                                continue;
                            }
                            if ("boundary_max_scan".equals(topLevelFieldName) || "boundaryMaxScan".equals(topLevelFieldName)) {
                                field2.boundaryMaxScan(parser.intValue());
                                continue;
                            }
                            if ("boundary_chars".equals(topLevelFieldName) || "boundaryChars".equals(topLevelFieldName)) {
                                char[] charsArr = parser.text().toCharArray();
                                Character[] boundaryChars = new Character[charsArr.length];
                                for (int i = 0; i < charsArr.length; ++i) {
                                    boundaryChars[i] = Character.valueOf(charsArr[i]);
                                }
                                field2.boundaryChars(boundaryChars);
                                continue;
                            }
                            if ("type".equals(fieldName)) {
                                field2.highlighterType(parser.text());
                                continue;
                            }
                            if ("fragmenter".equals(fieldName)) {
                                field2.fragmenter(parser.text());
                                continue;
                            }
                            if ("no_match_size".equals(fieldName) || "noMatchSize".equals(fieldName)) {
                                field2.noMatchSize(parser.intValue());
                                continue;
                            }
                            if (!"phrase_limit".equals(fieldName) && !"phraseLimit".equals(fieldName)) continue;
                            field2.phraseLimit(parser.intValue());
                            continue;
                        }
                        if (token2 != XContentParser.Token.START_OBJECT) continue;
                        if ("highlight_query".equals(fieldName) || "highlightQuery".equals(fieldName)) {
                            field2.highlightQuery(context.queryParserService().parse(parser).query());
                            continue;
                        }
                        if (!fieldName.equals("options")) continue;
                        field2.options(parser.map());
                    }
                    fields.add(field2);
                }
                continue;
            }
            if (!"highlight_query".equals(topLevelFieldName) && !"highlightQuery".equals(topLevelFieldName)) continue;
            globalHighlightQuery = context.queryParserService().parse(parser).query();
        }
        if (globalPreTags != null && globalPostTags == null) {
            throw new SearchParseException(context, "Highlighter global preTags are set, but global postTags are not set");
        }
        for (SearchContextHighlight.Field field3 : fields) {
            if (field3.preTags() == null) {
                field3.preTags(globalPreTags);
            }
            if (field3.postTags() == null) {
                field3.postTags(globalPostTags);
            }
            if (field3.highlightFilter() == null) {
                field3.highlightFilter(globalHighlightFilter);
            }
            if (field3.scoreOrdered() == null) {
                field3.scoreOrdered(globalScoreOrdered);
            }
            if (field3.fragmentCharSize() == -1) {
                field3.fragmentCharSize(globalFragmentSize);
            }
            if (field3.numberOfFragments() == -1) {
                field3.numberOfFragments(globalNumOfFragments);
            }
            if (field3.encoder() == null) {
                field3.encoder(globalEncoder);
            }
            if (field3.requireFieldMatch() == null) {
                field3.requireFieldMatch(globalRequireFieldMatch);
            }
            if (field3.boundaryMaxScan() == -1) {
                field3.boundaryMaxScan(globalBoundaryMaxScan);
            }
            if (field3.boundaryChars() == null) {
                field3.boundaryChars(globalBoundaryChars);
            }
            if (field3.highlighterType() == null) {
                field3.highlighterType(globalHighlighterType);
            }
            if (field3.fragmenter() == null) {
                field3.fragmenter(globalFragmenter);
            }
            if (field3.options() == null || field3.options().size() == 0) {
                field3.options(globalOptions);
            }
            if (field3.highlightQuery() == null && globalHighlightQuery != null) {
                field3.highlightQuery(globalHighlightQuery);
            }
            if (field3.noMatchSize() == -1) {
                field3.noMatchSize(globalNoMatchSize);
            }
            if (field3.phraseLimit() != -1) continue;
            field3.phraseLimit(globalPhraseLimit);
        }
        context.highlight(new SearchContextHighlight(fields));
    }
}

